$(document).ready(function($){
    window.gSateliteWhite.jsSelect();
    $("input[name^='fecha']").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $("input[name^='fecha']").mask("99-99-9999");
    $("#checkAll").hide('slide');

    $("#buscar").click(function(event){
        var fecha_ini = $("#fecha_ini").val();
        var fecha_fin = $("#fecha_fin").val();
        var empleado = $("#empleado").val();
        var estado = $("#estado").val();
        if (fecha_ini == "" || fecha_fin == "") {
            crear_alerta('warning', 'Período de Fechas', 'Ambas fechas son requeridas.');
            return false;
        }
        verifica_fecha(fecha_ini,fecha_fin);
        if($("#fecha_fin_error").text() == ''){
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj+'acciones_personal/consultas/consulta_horas',
                data: {
                    fecha_ini: fecha_ini,
                    fecha_fin: fecha_fin,
                    empleado: empleado,
                    estado: estado
                },
                beforeSend: function(){
                    wait.start();
                },
                success: function(data){
                    if(data.tabla != ''){
                        $(".botones_export_print").show('slow');
                        $("#contenido").html(data.tabla); 
                        $("#contenido").show();
                        setTimeout(function() {$('#checkAll').dataTable();}, 100);
                    }
                    wait.close();
                }
            });
        }
    });

    $("#empleado").change(function(event){
        $("#empleado").removeClass('error');
        $("#empleado_error").text('');
    });

    $("#fecha_ini").focus(function(event){
        $("#fecha_ini").removeClass('error');
        $("#fecha_ini_error").text('');
    });

    $("#fecha_fin").focus(function(event){
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
    });

    function verifica_fecha(fecha_ini, fecha_fin){
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
            $("#fecha_fin").addClass('error');
            $("#fecha_fin_error").text("Verifique las fechas del período");
            return false;
        } else {
            $("#fecha_fin").removeClass('error');
            $("#fecha_fin_error").text('');
            return true;
        }        
    }


});