$(document).ready(function($){
    $('select').select2({placeholder: 'Seleccione una opcion'});
    $("input[name^='fecha']").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $("input[name^='fecha']").mask("99-99-9999");
    $("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");
    aplicar_fancy();

    $("#buscar").click(function(event){
        var fecha_ini = $("#fecha_ini").val();
        var fecha_fin = $("#fecha_fin").val();
        var empleado = $("#empleado").val();
        // var tipo = $("#tipo").val();
        var tipo = ($.isArray($("#tipo").val())) ? $("#tipo").val().toString() : "";
        verifica_fecha(fecha_ini,fecha_fin);
        if(fecha_ini != "" && fecha_fin != ""){
            if($("#fecha_fin_error").text()==''){         
                $.ajax({
                    dataType: 'json',
                    type: 'POST',
                    url: urlj+'acciones_personal/consultas/consultar_acciones',
                    data: {
                        fecha_ini:fecha_ini,
                        fecha_fin:fecha_fin,
                        empleado:empleado,
                        tipo:tipo
                    },
                    beforeSend: function(){
                        wait.start();
                    },
                    success: function(data){
                        wait.close();  
                        if(data.tabla!=''){
                            $(".botones_export_print").show('slow');
                            $("#contenido").show();
                            $("#contenido").html(data.tabla);             
                            setTimeout(function() {$('#checkAll').dataTable();}, 100);
                            aplicar_fancy();
                        }
                    }
                });
            }
        }else{ 
            if(fecha_ini == "") {
                $("#fecha_ini_error").text('Campo requerido');
            }
            if (fecha_fin == "") {
               $("#fecha_fin_error").text('Campo requerido');
            }
        }
    });

   $("#empleado").change(function(event){
      $("#empleado").removeClass('error');
      $("#empleado_error").text('');
    });

   $("#tipo").change(function(event){
      $("#tipo").removeClass('error');
      $("#tipo_error").text('');
    });

  $("#fecha_ini").focus(function(event){
      $("#fecha_ini").removeClass('error');
      $("#fecha_ini_error").text('');
  });
   $("#fecha_fin").focus(function(event){
      $("#fecha_fin").removeClass('error');
      $("#fecha_fin_error").text('');
  });


function verifica_fecha(fecha_ini, fecha_fin){
        //Convierto la fecha a Y-m-d
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        // var f1 = new Date(fecha_i);
        // var f2 = new Date(fecha_f);

        if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#fecha_fin_error").text(''); return true;}
        
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
          //crear_alerta('error','Error','Verifique las fechas del período');
          $("#fecha_fin").addClass('error');
          $("#fecha_fin_error").text("Verifique las fechas del período");
          return false;
        }

        if(Date.parse(fecha_i) < Date.parse(fecha_f)){
          $("#fecha_fin").removeClass('error');
          $("#fecha_fin_error").text('');
          return true;
        }
    }

});

function aplicar_fancy() {
    $(".verAnexo").fancybox({
        openEffect: 'elastic',
        closeEffect: 'elastic',
        href: $(this).attr('href'),
        type: 'iframe',
        helpers: {
            title: {
                type: 'inside'
            }
        }
    });
}