var pathArray = window.location.pathname.split( '/' );
var urlj = url_base_proyecto;
$(document).ready(function(){
    //Aplicar estilo a los select a algunos tab de ficha general
    $("#tipo_promocion, #departamento, #puesto").select2();
    $('#departamento').select2('disable', true);   
    $('#puesto').select2('disable', true);
    $('#puesto, departamento').attr('disabled', 'disabled');        
    $("#enf_estatura").numeric();
    $(".fecha_general").mask("99-99-9999");
    $(".fecha_general").attr('placeholder',"dd-mm-yyyy"); 
    $(".fecha_general").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    
    $("#promocion_nivelacion").validate({
        rules: {
            tipo_promocion: { required: true},
            salario: { required: true },
            puesto: { required: true },
            fecha_efectiva: { required: true }
        },
        ignore:":disabled",
        messages: { }, // campo de control
        //ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').html(error);
        },
        submitHandler: function(form) {            
            // if (!validar_fecha($("#fecha_efectiva").val())) {
            //     wait.close();
            //     crear_alerta('error', 'Información', 'La fecha efectiva no puede estar dentro de un rango actual');
            //     return false;
            // }
            if ($("#fecha_efectiva").val() == '') {
                wait.close();
                crear_alerta('error', 'Información', 'Debe asignar una fecha al campo de fecha efectiva');
                return false;
            }
            form.submit();
        }
    });

    $("#salario").blur(function(){
        // var sal_ant = $('#actual').val();
        // var new_sal = $(this).val();
        // if (parseFloat(new_sal) < parseFloat(sal_ant)) {
        //     crear_alerta('error','Atención','Nuevo Salario No debe ser Menor al Antiguo.'); 
        //     $(this).val('');
        //     return false;
        // }
    });


    $("#departamento").change(function(event){
        var depto = $(this).val();      
        $.ajax({
            type:'post',
            data: {depto:depto},
            url: urlj+'expediente_personal/empleado/get_plazasxdepto',
            beforeSend: function(){
                if ($("#tipo_promocion").val() != 3) {
                    $("#puesto").attr("placeholder","Cargando..."); 
                    $("#puesto").select2();
                }
            },
            success: function(data){
                $("#puesto").attr("placeholder","Seleccione");
                $("#puesto").html(data);
                $("#puesto option[value=0]").val('');
                $("#puesto").select2();
            }
        });
    });

    $("#tipo_promocion").change(function(event){
        //1:Promocion interna | 2:Nivelacion Salarial | 3:Traslado a otra area
        var promo = $(this).val();
        $("#puesto option:selected").removeAttr('selected');
        $("#departamento option:selected").removeAttr('selected');
        $("#departamento, #puesto").removeAttr('required');
        $("#departamento, #puesto").removeAttr('disabled');
        $("#departamento, #puesto").select2();
        $('#departamento, #puesto').select2('enable');
        switch(promo) {
            case '1':                        
                $('#departamento, #puesto').select2('enable');                       
                $('#departamento, #puesto').removeAttr('disabled');           
                $('#salario').val("");
                $('#salario').removeAttr("readonly");
                break;
            case '2':
                $('#puesto, #departamento').select2();
                $('#puesto, #departamento').select2('disable');
                $('#puesto, #departamento').attr('disabled', 'disabled');
                $('#salario').val("");
                $('#salario').removeAttr("readonly");
                break;
            case '3':
                $('#departamento').attr("required", true);
                $('#puesto, #departamento').select2();
                $('#puesto').select2('disable');
                $('#puesto').attr('disabled', 'disabled');
                $('#salario').val($('#actual').val());
                $('#salario').attr("readonly", true);
                $('#departamento').select2('enable');                       
                break;
            default:
                $('#salario').val("");
                $('#departamento, #puesto').select2('disable');
                $('#puesto, #departamento').attr('disabled', 'disabled');           
                break;
        }
    });

    $("#puesto").change(function() {
        var plaza = $(this).val();
        if (plaza > 0) {
            $.ajax({
                type:'post',
                data: {plaza:plaza},
                url: urlj + 'expediente_personal/empleado/get_deptoxplaza',
                beforeSend: function(){
                    wait.start();
                },
                success: function(data){
                    if (data != "") {
                        $("#departamento").html(data);
                        $("#departamento").select2({placeholder: "Seleccione"});
                        wait.close();
                    }                        
                }
            });
        }
    });
    
});

function validar_fecha(fecha) {
    var validacion = true;
    $.ajax({
        type: 'post',
        data: { fecha: fecha,
            id_emp: $("#id_empleado").val()
         },
        async: false,
        url: urlj + 'acciones_personal/principal/validar_fecha_promocion',
        beforeSend: function () {
            wait.start();
        },
        success: function (data) {
            if  (data > 0){
                validacion = false;
            }
        }
    });

    return validacion;
}




