$(document).ready(function() {

    $("select").select2();
    $(".fechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".fechas").mask("99-99-9999");

    $("#btnConsulta").on("click", function() {
        var estado = $("#slcEstado").val();
        var fecha_ini = $("#fecha_ini").val();
        var fecha_fin = $("#fecha_fin").val();
        if (fecha_ini == "" || fecha_fin == "") {
            crear_alerta('error', 'Atención', 'Ambas fechas son requeridas.');
            return false;
        }
        if(!verifica_fecha(fecha_ini, fecha_fin)){
            crear_alerta('error', 'Atención', 'Verifique el rango de fechas.');
            return false;
        }
        $.ajax({
	        type: 'POST',
	        url: urlj + 'acciones_personal/principal/aprobar_compensatorios',
	        data: {estado: estado, fecha_ini: fecha_ini, fecha_fin: fecha_fin},
	        beforeSend: function () {
                wait.start('Cargando..');
                $("#dv_contenedor").hide("slide", {
                    direction: 'right'
		        }, 500); 	             
	        },
	        success: function(data){
	            $("#tbl_contenedor").dataTable().fnDestroy();	        	
	            $("#tbContenedor").html(data);
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);	            
	            aplicar_datatable('#tbl_contenedor');
	            wait.close();
	        }
	    });
    });

    $("body").on('click', ".ver_accion_modal", function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width: '100%',
            height: '100%',
            closeBtn: true,
            beforeClose: function () {
                $("#btnConsulta").trigger("click");
            }
        });
    });


});

function aplicar_datatable(id){
    $(id).dataTable({
        "bFilter": true,
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin){    
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error','Periodo Fechas','Verifique las fechas del período');
        return false;
    } else {
        return true;
    }
}
