$(document).ready(function($) {
	$("input[name^='fecha']").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
	$("input[name^='fecha']").mask("99-99-9999");
	$("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");

	$("#fecha_ini, #fecha_fin").change(function(event){
		if ($("#fecha_ini").val() != "" && $("#fecha_fin").val() != "") {
			fecha_valida($("#fecha_ini").val(), $("#fecha_fin").val());
		}
		/*
		jQuery.validator.addMethod("fecha_ini_fin", function(value, element, params) {
			ini = $(params[0]).val();
			fin = $(params[1]).val();
			fecha_i = ini.split("-").reverse().join("-");
			fecha_f = fin.split("-").reverse().join("-");
			return this.optional(element) || ( Date.parse(fecha_i) <= Date.parse(fecha_f) );			
		}, jQuery.validator.format("Verifique las fechas del periodo."));
		jQuery.validator.addMethod("fecha", function(value, element) {
			// dd/mm/yyyy
			var re = /^\d{1,2}\-\d{1,2}\-\d{4}$/;
			// valid if optional and empty OR if it passes the regex test
			return (this.optional(element) && value=="") || re.test(value);
		}, jQuery.validator.format("Verifique las fechas del periodo."));
		*/
	});

	  
	$('#frm_solicitud').validate({
		ignore: null,
		ignore: 'input[type="hidden"]',
		rules: {
			fecha_ini:{required:true},
			fecha_fin:{required:true},
		},
		errorPlacement: function (error, element) {
			if($(element).is("select")){
				$(element).next().append(error);
			} else {
				error.insertAfter(element);
			}
			$("[for=fecha_ini]").css("margin-left", "17%");
			$("[for=fecha_fin]").css("margin-left", "17%");
			$("[for=fecha_ini_fin]").css("margin-left", "17%");
		},
		submitHandler: function(form){
			if (fecha_valida($("#fecha_ini").val(), $("#fecha_fin").val())) {
				wait.start();
				$("#contenedor_consulta").hide("slide", { direction: 'right' }, 400, function() {
					$.ajax({
						type: 'post',
						url:  window.gSateliteWhite.baseUrl('acciones_personal/principal/calculo_liquidacion/1'),
						data: $("#frm_solicitud").serialize(),
						success: function (data) {
							$("#contenedor_consulta").html(data);
							wait.close();
							$("#contenedor_consulta").show("slide", { direction: 'left' }, 500);
							$("#tabla").dataTable();
						}
					});
				});
			} else {
				wait.close();
				return false;
			}
		}
	}); 

});


function fecha_valida(fecha_ini, fecha_fin) {
    var start = fecha_ini.split("-").reverse().join("-");
    var final = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(start) > Date.parse(final)) {
        crear_alerta('error', 'Verifique las fechas del período', '');
        return false;
    } else {
    	return true;
    }    
}