$(document).ready(function(){
	window.gSateliteWhite.jsSelect();

	$(".uploader").attr('title', 'Seleccione un archivo CSV');
	$(".uploader").tooltip();
	$(".oculto").hide();
	$(".ayuda").click(function(event) {
		html=$("#div_ayuda").html();
		$.fancybox(html,{title:'FORMATO CSV PARA SER PROCESADO'});
	});


	$("#tipo_planilla").change(function(event) {
		cargarPeriodos($(this).val());
	});

	$("#tipo_hora_extra").change(function(event) {
	  	if($(this).val()>0){
	       $.ajax({
		        url: window.gSateliteWhite.baseUrl('acciones_personal/principal/registro_tipo_hora_extra'),
		        type: 'post',
		        dataType: 'json',
		        data: { 'id_tipo': $(this).val() },
		        success: function(data) {
		         $("#factor_multiplica").val(data.factor_multiplica);
		        }
		    });
	  	} else {
	    	$("#factor_multiplica").val('');
	  	}
	});

	$("#cargar_pre").on('click',function(){

		$("#contenedor_info").html('');
		$("#contenedor_resultado_ex, .oculto").hide();
		var file_data = $('#csv_extras').prop('files')[0];  

		var planilla = $('#tipo_planilla').val();
		var periodo = $('#periodo_planilla').val();
		var tipo = $('#tipo_hora_extra').val(); 


		var form_data = new FormData();     
		form_data.append('csv_extras',file_data);

		var objArr = [];
		objArr.push({"csv_planilla":planilla, "csv_periodo":periodo,"csv_tipo":tipo});

		console.log(objArr); 
		form_data.append('data', JSON.stringify(objArr));

		if(planilla>0 && periodo > 0 && tipo >0){


			if(validar_archivo()){
				$.ajax({
					dataType:'json',
					type:'post',
					cache: false,
					contentType: false,
					processData: false,
					data: form_data,
					url: window.satelite.base_url('acciones_personal/principal/horas_extras_masivas'),
					beforeSend: function(){
						wait.start();
					},
					success: function(data){
						wait.close();
						$("#csv_extras").val('');
						$("#ciclico_nombre").val(data.nombre);
						$("#ciclico_ruta").val(data.ruta);
						$(".filename").text("No file selected");
						if(data.drop == ''){
							crear_alerta("success","Éxito","Carga de datos realizada con éxito");
						} else {
							$("#contenedor_info").html(data.drop);
							$("#contenedor_resultado_ex, .oculto").show("slide");
						}
						
					}
				})
			}
		}else{
			crear_alerta('error', 'Campos requeridos', 'Debe completar los campos requeridos.');
		}
	});


$("body").on('click', '.eliminar_fila', function(event) {
	event.preventDefault();
	$(this).parent().parent().remove();
	$("#cantidad_registro").val($("#contenedor .reg_correcto").length);
});


$("#cancelar").click(function(event){
	alerta_confirm_ajax(regresar,1,'Confirmar eliminar registro','Los datos cargados aun no han sido guardados. ¿Éstas seguro que desea cancelar el proceso?');
});

 $("#form_vista_csv").validate({
     ignore: "",
     rules: {
         cantida_registro: {required: true, min:1}
     },
     messages: {
         cantida_registro: "Debe existir al menos un registro para ser procesado"
     },
     ignore: ".select2-container",
     errorPlacement: function (error, element) {
         if (element.is('select'))
         {
             $(element).next().append(error);
         }
         else
         {
             error.insertAfter(element);
         }

     },
     submitHandler: function (form) {
     	 wait.start();
	     form.submit();
    }
});


});


function regresar(data) {
	window.location.href = window.satelite.base_url('acciones_personal/principal/horas_extras_masivas');
}

function cargarPeriodos(id_pla) {
      if(id_pla>0){
           $.ajax({
            url: window.gSateliteWhite.baseUrl('acciones_personal/principal/periodos_planilla'),
            type: 'post',
            dataType: 'json',
            data: {
                'idpla': id_pla
            },
            beforeSend: function () {
            $("#contenedor_select_periodo_planilla").html('<select name="periodo_planilla" required id="sinR" style="width:300px;" placeholder="Cargando..."><option value=""></option></select>'); 
            $("#sinR").select2();
            },
            success: function(data) {
              if (data.posee == true) {
              $("#contenedor_select_periodo_planilla").html(data.select);
              $("select[name='periodo_planilla']").attr('id', 'periodo_planilla');
              $("select[name='periodo_planilla']").attr('placeholder', 'Seleccione');
              $("select[name='periodo_planilla']").attr('class', 'nostyle');
              $("select[name='periodo_planilla']").attr('required', 'required');
              $("#periodo_planilla").select2();
          }
          else {
            $("#sinR").attr('placeholder', 'Sin Registros');
            $("#sinR").select2('destroy').select2();
         } 

            }
        });
      }
      else {
        $("#contenedor_select_periodo_planilla").html('<select name="periodo_planilla" disabled required id="periodo_planilla" class="nostyle" placeholder="Seleccione"><option value=""></option></select>');
        $("#periodo_planilla").select2();
      }
  }


function validar_archivo() {

	valor = $("#csv_extras").val();
	if(valor!="") {

		extension = (valor.substring(valor.lastIndexOf("."))).toLowerCase(); 
		if(extension=='.csv'){
			return true;
		} else {
			$("#muestra_error_file").text('Debe ser un archivo con extensión .csv');
			return false;
		}
	}
	else {
		$("#muestra_error_file").text('Archivo con extensión .csv requerido');
		return false;
	}
}


