$(document).ready(function($){
    $("#acciones").hide();
    $(".calendario").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $(".calendario").mask("99-99-9999");
    $("select").select2({placeholder: 'Seleccione'});

    $("body").on("change", "#fecha_ini, #fecha_fin", function(){
        verifica_fecha($('#fecha_ini').val(), $('#fecha_fin').val());
    });

    $("#buscar").click(function(event){
        var fecha_ini = $("#fecha_ini").val();
        var fecha_fin = $("#fecha_fin").val();
        var empleado  = $("#empleado").val();
        verifica_fecha(fecha_ini,fecha_fin);
        if (fecha_ini != "" && fecha_fin != "") {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj+'acciones_personal/consultas/rpt_goce_vacaciones/1',
                data: {
                    fecha_ini: fecha_ini,
                    fecha_fin: fecha_fin,
                    empleado: empleado, 
                    tipo_reporte: ""
                },
                beforeSend: function(){
                    wait.start();
                },
                success: function(data){
                    if(data.tabla!=''){
                        $("#contenido").html(data.tabla);
                        if (data.filas > 0) {
                            $("#acciones").show('slow');
                            $("#h_fecha_ini").val(fecha_ini);
                            $("#h_fecha_fin").val(fecha_fin);
                            $("#h_empleado").val(empleado);
                        }
                        setTimeout(function() {$('#tabla_vacaciones').dataTable();}, 100);
                        wait.close();  
                    }

                }
            });
        } else {
            crear_alerta('error', 'Atención', 'Ambas fechas son requeridas');
        }
    });

});

function verifica_fecha(fecha_ini, fecha_fin){
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
            crear_alerta('error', 'Atención', 'Verifique las fechas del período');
            return false;
        } else {
            return true;
        }
    }