var urlj = url_base_proyecto;

$(document).ready(function(){

    $('select').select2({placeholder: "Seleccione"});

    $("#txt_calculo_hasta").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $("#txt_calculo_hasta").mask("99-99-9999");
    
    $('#btn_liquidacion').click(function(){
        if ($("#txtTotalPagar").val() > 0 && $("#pla_pagar").val() != "" && $("#txt_calculo_hasta").val() != ""){
            alerta_confirm_ajax(enviar_formulario,1,'Confirmación de registro','¿Realmente desea guardar los cálculos actuales?');
        } else {
            if (!($("#txtTotalPagar").val() > 0)) {
                crear_alerta("error",'Total requerido','');
                return false;
            }
            if (!($("#txt_calculo_hasta").val() != "")) {
                crear_alerta("error",'Fecha de cálculo requerida','');
                return false;
            }
            if (!($("#pla_pagar").val() > 0)) {
                crear_alerta("error",'Período de planilla requerido','');
                return false;
            }
        }        
    });

    $("#pla_pagar").change(function() {
        if ($(this).val() > 0) {
            var codigo = $("#pla_pagar option:selected").data('cod');
            var fe_ini = $("#pla_pagar option:selected").data('ini');
            var fe_fin = $("#pla_pagar option:selected").data('fin');
            $("#codigo_pla").val(codigo);
            $("#inicio_pla").val(fe_ini);
            $("#fin_pla").val(fe_fin);
        } else {
            $("#codigo_pla, #inicio_pla, #fin_pla").val("");
        }
    });

    $("#txt_calculo_hasta").change(function() {
        var guardada = $("#fecha_guardada").val();
        var esta_fecha = $("#txt_calculo_hasta").val();
        var es_edicion = ($("#es_edit").val() > 0) ? true : false;
        if (es_edicion && $.trim(guardada) != "") {
            alerta_confirm_ajax(cambia_fecha, esta_fecha, 'Confirmación de Cambio', '¿Realmente desea cambiar la fecha de los cálculos actuales? Deberá volver a realizar el proceso de cálculo', misma_fecha, guardada);
        }
    });

    if ($("#pla_pagar").val() > 0) {
        $("#pla_pagar").trigger('change');
    }

    $("input[type='checkbox']").iButton({
        'labelOn': ' Si ',
        'labelOff': ' No ',
        'resizeHandle': false,
        'resizeContainer': false
    });

    $(".porcent").keypress(function(event) {
        if ($(this).val() > 100) {
            $(this).val("100");
        }
    });

    $(".porcent").keyup(function(event) {
        if ($(this).val() > 100) {
            $(this).val("100");
        }
    });

    $(".btnDetalle").attr('style', 'display:none');

    $('#btnCalcular').click(function(){
        var hasta = $("#txt_calculo_hasta").val();
        if ($.trim(hasta) != "") {
            $.ajax({
                url: urlj + 'acciones_personal/principal/get_calculos_indemnizacion',
                type: 'POST',
                dataType: 'json',
                data: {
                    txtFechaHasta: hasta,
                    ckcAplicaAguinaldo: ($("#ckcAplicaAguinaldo").attr('checked')) ? 1 : 0,
                    ckcAplicaDiasLaboralesAguinaldo: ($("#ckcAplicaDiasLaboralesAguinaldo").attr('checked')) ? 1 : 0,
                    txtPorcentajeAgui: ($("#txtPorcentajeAgui").val() > 0) ? $("#txtPorcentajeAgui").val()/100 : 1,
                    ckcAplicaVacacion: ($("#ckcAplicaVacacion").attr('checked')) ? 1 : 0,
                    ckcAplicaDiasLaboralesVaca: ($("#ckcAplicaDiasLaboralesVaca").attr('checked')) ? 1 : 0,
                    txtPorcentajeVaca: ($("#txtPorcentajeVaca").val() > 0) ? $("#txtPorcentajeVaca").val()/100 : 1,
                    ckcAplicaIndemnizacion: ($("#ckcAplicaIndemnizacion").attr('checked')) ? 1 : 0,
                    ckcAplicaDiasLaboralesIndem: ($("#ckcAplicaDiasLaboralesIndem").attr('checked')) ? 1 : 0,
                    txtPorcentajeIndem: ($("#txtPorcentajeIndem").val() > 0) ? $("#txtPorcentajeIndem").val()/100 : 1,
                    ckcAplicaSalario: ($("#ckcAplicaSalario").attr('checked')) ? 1 : 0,
                    txtPorcentajeSala: ($("#txtPorcentajeSala").val() > 0) ? $("#txtPorcentajeSala").val()/100 : 1,
                    id_empleado_liquidacion: id_empleado,
                    id_tipo_planilla: id_tipo_planilla,
                    txtAguiDias: 0
                },
                beforeSend: function () {
                    wait.start();
                },
                error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    $("#txtTotalPagar").val(json.total_pagar.toFixed(2));
                    $("#detalles_ingresos").html(json.html_ingreso);
                    $("#detalles_descuentos").html(json.html_descuento);
                    //alimentar las variables globales
                    total_ingreso = json.total_ingreso;
                    total_descuento = json.total_descuento;
                    total_pagar = json.total_pagar;
                    wait.close();
                }
            });
        } else {
            crear_alerta('error', 'veriifque los campos requeridos');
            return false;
        }
    });

});

function mostrar_detalle_aguinaldo() {
    if ($("#ckcAplicaDiasLaboralesAguinaldo").attr('checked')) {
        $("#btnDetAguinaldo").removeAttr('style');
    } else {
        $("#btnDetAguinaldo").attr('style', 'display:none');
    }
}

function mostrar_detalle_vacacion() {
    if ($("#ckcAplicaDiasLaboralesVaca").attr('checked')) {
        $("#btnDetVacacion").removeAttr('style');
    } else {
        $("#btnDetVacacion").attr('style', 'display:none');        
    }
}

function mostrar_detalle_indem() {
    if ($("#ckcAplicaDiasLaboralesIndem").attr('checked')) {
        $("#btnDetIndem").removeAttr('style');
    } else {
        $("#btnDetIndem").attr('style', 'display:none');        
    }
}

function cambia_fecha(new_fecha) {
    $("#fecha_guardada").val(new_fecha);
    $("#detalles_ingresos, #detalles_descuentos").html('<tr><td colspan="2"  style="text-align:center" >Sin registros</td></tr>');
    $("#txtTotalPagar").val('0.00');
}

function misma_fecha(old_fecha) {
    $("#txt_calculo_hasta").val(old_fecha);
}

function enviar_formulario() {
    //agregar en inputs ocultos las variables para generación del periodo
    $("#total_ingreso").val(total_ingreso);
    $("#total_descuento").val(total_descuento);
    $("#total_pagar").val(total_pagar);
    $("#frmLiquidacion").submit();  
}