var pathArray = window.location.pathname.split( '/' );
var urlj=url_base_proyecto;

$(document).ready(function(){
    //Aplicar estilo a los select a algunos tab de ficha general
    $("#tipo_promocion, #departamento, #puesto").select2();
    
    $(".fecha_general").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $(".fecha_general").attr('placeholder',"dd-mm-yyyy"); 
    $(".fecha_general").mask("99-99-9999");

    $("#promocion_nivelacion").validate({
        rules: {
            tipo_promocion:{ required: true},
            salario: { required: true },
            puesto: { required: true },
            fecha_efectiva: { required: true }         
        },
        ignore:":disabled",
        messages: { }, // campo de control
        //ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').html(error);
        },
        submitHandler: function(form) {
            // console.log(form);
            if (!validar_fecha($("#fecha_efectiva").val())) {
                wait.close();
                crear_alerta('error', 'Información', 'La fecha efectiva no puede destar dentro de un rango actual');
                return false;
            }
            form.submit();
        }
    });

    $("#salario").blur(function(){
        // var sal_ant = $('#actual').val();
        // var new_sal = $(this).val();
        // if (parseFloat(new_sal) < parseFloat(sal_ant)) {
        //     crear_alerta('error','Atención','Nuevo Salario No Debe ser Menor al Antiguo.'); 
        //     $(this).val('');
        //     return false;
        // }
    });

    if ($("#tipo_actual").val() == 2) {
        $("#puesto, #departamento").select2("disable");
    } else if ($("#tipo_actual").val() == 3) {
        $("#puesto").select2("disable");
    } else {
        $("#puesto, #departamento").select2("enable");
    }


    $("#departamento").change(function(event){
        var depto = $(this).val();
        $.ajax({
            type:'post',
            data: {depto:depto},
            url: urlj+'expediente_personal/empleado/get_plazasxdepto',
            beforeSend: function(){
                if ($("#tipo_promocion").val() != 3) {
                    $("#puesto").attr("placeholder","Cargando..."); 
                    $("#puesto").select2();
                }
            },
            success: function(data){
                if ($("#tipo_promocion").val() != 3) {
                    $("#puesto").attr("placeholder","Seleccione");
                    $("#puesto").html(data);
                    $("#puesto option[value=0]").val('');
                    $("#puesto").select2();
                }
            }
        });
    });

    $("#puesto").change(function() {
        var plaza = $(this).val();
        if (plaza > 0) {
            $.ajax({
                type:'post',
                data: {plaza:plaza},
                url: urlj + 'expediente_personal/empleado/get_deptoxplaza',
                beforeSend: function(){
                    wait.start();
                },
                success: function(data){
                    if (data != "") {
                        $("#departamento").html(data);
                        $("#departamento").select2({placeholder: "Seleccione"});
                        wait.close();
                    }                        
                }
            });
        }
    });

    $("#tipo_promocion").change(function(event){
        //1:Promocion interna | 2:Nivelacion Salarial | 3:Traslado a otra area
        var promo = $(this).val();
        var actual = $("#tipo_actual").val();
        var actuales = $("#slc_plaza_act").val();//plazas actuales
        var dispnbls = $("#slc_plaza_dis").val();//plazas disponibles
        var are_actl = $("#slc_are_actl").val(); 
        //console.log(actual);
        //console.log(dispnbls);
        //console.log(are_actl);
        $("#puesto option:selected").removeAttr('selected');
        $("#departamento option:selected").removeAttr('selected');
        $("#departamento, #puesto").removeAttr('required');
        $("#departamento, #puesto").removeAttr('disabled');
        $("#departamento, #puesto").select2();
        $('#departamento, #puesto').select2('enable');
        switch(promo) {
            case '1':
                //PROM.INTERNA
                if (actual > 1) {
                    $('#puesto').select2('destroy');
                    $('#puesto').html(dispnbls);
                    $('#puesto').select2();
                    $('#puesto').trigger('change');
                } else {
                    $('#puesto, #departamento').select2('destroy');
                    $('#puesto').html(actuales);
                    $('#departamento').html(are_actl);
                    $('#puesto, #departamento').select2();
                }                
                $('#departamento, #puesto').select2('enable');                       
                $('#departamento, #puesto').removeAttr('disabled');           
                break;
            case '2':
                $('#puesto, #departamento').select2('destroy');
                $('#puesto').html(actuales);
                $('#departamento').html(are_actl);
                $('#puesto, #departamento').select2();
                $('#puesto, #departamento').select2('disable');
                $('#puesto, #departamento').attr('disabled', 'disabled');
                break;
            case '3':
                $('#departamento').html(are_actl);//el area actual
                $('#departamento').attr("required", true);
                $('#puesto, #departamento').select2();
                $('#puesto').select2('disable');
                $('#puesto').attr('disabled', 'disabled');
                $('#departamento').select2('enable');                       
                break;
            default:
                $('#departamento, #puesto').html('<option value=""></option>');
                $('#departamento, #puesto').select2('disable');
                $('#puesto, #departamento').attr('disabled', 'disabled');           
                break;
        }      
    });
    
});

function validar_fecha(fecha) {
  var validacion = true;
  var url = window.location.pathname;
  var spli_url = url.split('/');
  $.ajax({
    type: 'post',
    data: {
      fecha: fecha,
      id_emp: $("#id_empleado").val(),
      id_pps: spli_url.pop()
    },
    async: false,
    url: urlj + 'acciones_personal/principal/validar_fecha_promocion',
    beforeSend: function () {
      wait.start();
    },
    success: function (data) {
      if (data > 0) {
        validacion = false;
      }
    }
  });

  return validacion;
}



