$(document).ready(function($){
    $("select").select2({placeholder: 'Seleccione'});
    $("#acciones").hide();

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });    
    $(".datePicker").mask("99-99-9999");

    $("#slcEmpleado").select2({
        placeholder: "Buscar Empleado",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'expediente_personal/reportes/get_empleados_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (empresa) {
                return {
                    empresa: empresa
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.id,
                        'text': item.nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });


    $("#btn_buscar").click(function(event){
        var desde = "";// $("#fDesde").val();
        var hasta = "";// $("#fHasta").val();
        var tipo = $("#slcTipo").val();
        var area = "";// $("#slc_area").val();
        var empl = "";// $("#slcEmpleado").val();
        $("#acciones").hide();
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj+'acciones_personal/consultas/consumos_permisos/1',
            data: {
                f_ini: desde,
                f_fin: hasta,
                area: area,
                empl: empl, 
                tipo_p: tipo, 
                tipo_reporte:""
            },
            beforeSend: function(){
                wait.start();
            },
            success: function(data){
                    // $("#year").val(year);
                    // $("#area").val(area);
                    // $("#empl").val(empl);
                    // $("#area").val(area);
                $("#contenido").html(data.tabla);
                if(data.filas > 0){
                    $("#tipo_p").val(tipo);
                    // $("#acciones").show('slow');
                }
                wait.close();
            }
        });
        
    });

});