$(document).ready(function () {
    
        $("#slc_area").select2();

        $(".datePicker").datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            closeText: 'Cerrar',
            currentText: 'Hoy'
        });
        $(".datePicker").mask('99-99-9999');
    
        $("#slc_area").live('change',function() {
            var area =  $("select[id='slc_area']").last().val();
            menor=Number($(this).attr('nid'))+2;
            $(".dinamic").each(function(index, el) {
                if($(el).attr('nid')>menor){
                    $(el).parent('div').siblings('label').remove();
                    $(el).siblings('select').remove();
                    $(el).parent('div').parent('div').parent('div').parent('div').remove();
                    $(el).remove();
                }
            });
            $(".plus:last").remove();
    
            $('.dinamic').each(function(index, el) {
                $(this).attr('nid', index);
            });
    
            if(area != ""){
                $(this).next().append('<button class="btn plus" value="'+area+'">+</button>');
                categoria_area = $("select[id='categoria']").last().val();
                $('#filtro_area').val(categoria_area);
            } else{
                var last_cat = "";
                $('.dinamic').each(function(index, el) {
                    if($(this).val() != "" ){
                        last_cat = $(this).val();
                    }
                });
                if(last_cat != ""){
                    $('#filtro_area').val(last_cat);
                } else{
                    $('#filtro_area').val("");
                }
            }
    
            $("#filtro_area").val(area);
        });
    
        $(".plus").live('click',function(event) {
            event.preventDefault();
            area = $(this).val();
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj+'estructura_organizativa/consultas/get_areas',
                data: {area:area},
                success: function(data){
                    $(".plus").last().remove();
                
                    if ( data.hijos == 1 ) {
                        numero = $('#div_areas select').last().length + 1;
                        html_areas = data.areas;
                        linea = $("#div_areas").append('<div class="form-row row-fluid">'
                            +'<div class="span6">'
                            +'<div class="row-fluid">'
                            +'<label class="form-label span3">Área: </label>'
                            +'<div class="span9 controls">'
                            +'<select id="slc_area" class="nostyle seleccion dinamic areas" name="filtro" style="width:100%" placeholder="Seleccione"></select>'
                            +'</div></div></div></div>'); 
                        linea2 = $('select[id="slc_area"]').last().html(); 
                        nueva = linea2.replace(/#/g, numero);
                        $('#div_areas').append(nueva);
                        $('select[id="slc_area"]').last().html(html_areas);
                        $('select[id="slc_area"]').last().select2();
    
                        $('.dinamic').each(function(index, el) {
                            $(this).attr('nid', index);
                        });
    
                    } else {
                        crear_alerta('info','Aviso','No se encontraron más dependencias.');
                    }
                }
            });
        });
        
    
        $(".areas").live('change',function(){
            $("#filtro_area").val( $(this).val() );
            $("#filtro_area_nombre").val( $("option:selected", this).text() );
        });
    
        $("#reporte").validate({
            rules: {
               
            },
            errorPlacement: function (error, element) {
                var nombre = $(element).attr("id");
                $("#" + nombre + "_error").html(error);
                crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
            },
            submitHandler: function (form){

                $("#filtro_inicio").val($("#txtFechaIni").val());
                $("#filtro_fin").val( $("#txtFechaFin").val());

                var fecha_ini =  $("#filtro_inicio").val();
                var fecha_fin = $("#filtro_fin").val();

                var area 		= $("#filtro_area").val();
                var nombre_area	= $("#filtro_area_nombre").val();

                $("#filtro_area").val(area);
                $("#filtro_area_nombre").val(nombre_area);

                if (fecha_ini == '' || fecha_fin == '') {
                    crear_alerta('error', 'Reporte de retiro de personal', 'Fechas son obligatorias.');
                    return false;
                }

                if (!validarPeriodo(fecha_ini, fecha_fin)) {
                        crear_alerta('error', 'Reporte de retiro de personal', 'Verifique el período de las fechas.');
                        return false;
                }
                
                form.submit();
            }
        });
    
        $("#btnConsultar").click(function(){
            event.preventDefault();
            var area 		= $("#filtro_area").val();
            var nombre_area	= $("#filtro_area_nombre").val();

            var fecha_ini = $("#txtFechaIni").val();
            var fecha_fin = $("#txtFechaFin").val();
    
            if (fecha_ini == '' || fecha_fin == '') {
                crear_alerta('error', 'Reporte de retiro de personal', 'Fechas son obligatorias.');
                return false;
            }
    
            if (!validarPeriodo(fecha_ini, fecha_fin)) {
                    crear_alerta('error', 'Reporte de retiro de personal', 'Verifique el período de las fechas.');
                    return false;
            }
            
    
            $("#dv_contenedor_listado").hide('slide', {
                direction: 'right'
            },
                    400, function () {
                        $.ajax({
                            type: 'post',
                            url: window.gSateliteWhite.baseUrl('acciones_personal/consultas/reporte_retiro_personal/1'),
                            data: {area: area,nombre_area:nombre_area,fecha_ini:fecha_ini,fecha_fin:fecha_fin},
                            beforeSend: function () {
                                wait.start();
                            },
                            success: function (result) {
                                wait.close();
                              
                                var obj = jQuery.parseJSON( result );
                             
                                var oTable = $('#tblListado').dataTable();
                                oTable.fnDestroy(); 
    
                                $("#tbContenedorListado").html(obj.html);
                             
                                aplicarDataTable('tblListado');
    
                                $("#dv_contenedor_listado").show("slide", {
                                    direction: 'left'
                                }, 500);

                                $("#filtro_area").val(area);
                                $("#filtro_area_nombre").val(nombre_area);

                                $("#filtro_inicio").val(fecha_ini);
                                $("#filtro_fin").val(fecha_fin);
    
                            }
                        });
                    }
            );
    
        });
    
    });
    
    function aplicarDataTable(idTabla) {
        $('#' + idTabla).dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 10,
            "bLengthChange": false,
            "bDestroy": true,
            "fnInitComplete": function (oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    }
    