$(document).ready(function () {
    
        $(".select").select2({placeholder : "Seleccione"});

        $(".datePicker").datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            closeText: 'Cerrar',
            currentText: 'Hoy'
        });

        $("#reporte").validate({
            rules: {
               
            },
            errorPlacement: function (error, element) {
                var nombre = $(element).attr("id");
                $("#" + nombre + "_error").html(error);
                crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
            },
            submitHandler: function (form){

                $("#filtro_inicio").val($("#txtFechaIni").val());
                $("#filtro_fin").val( $("#txtFechaFin").val());

                var fecha_ini =  $("#filtro_inicio").val();
                var fecha_fin = $("#filtro_fin").val();

                var area 		= $("#filtro_area").val();
                var nombre_area	= $("#filtro_area_nombre").val();

                $("#filtro_area").val(area);
                $("#filtro_area_nombre").val(nombre_area);

                if (fecha_ini == '' || fecha_fin == '') {
                    crear_alerta('error', 'Reporte de retiro de personal', 'Fechas son obligatorias.');
                    return false;
                }

                if (!validarPeriodo(fecha_ini, fecha_fin)) {
                        crear_alerta('error', 'Reporte de retiro de personal', 'Verifique el período de las fechas.');
                        return false;
                }
                
                form.submit();
            }
        });
    
        $("#btnConsultar").click(function(){
            event.preventDefault();
            
            var fecha_ini = $("#txtFechaIni").val();
            var fecha_fin = $("#txtFechaFin").val();

            var empleado = $("#slc_empleado").val();
            var tipo_incapacidad = $("#slc_tip_incapacidad").val();

            if (fecha_ini == '' || fecha_fin == '') {
                crear_alerta('error', 'Reporte de incapacidad', 'Fechas son obligatorias.');
                return false;
            }
    
            if (!validarPeriodo(fecha_ini, fecha_fin)) {
                    crear_alerta('error', 'Reporte de incapacidad', 'Verifique el período de las fechas.');
                    return false;
            }
            
            $("#dv_contenedor_listado").hide('slide', {
                direction: 'right'
            },
                    400, function () {
                        $.ajax({
                            type: 'post',
                            url: window.gSateliteWhite.baseUrl('acciones_personal/consultas/reporte_incapacidad/1'),
                            data: $("#reporte_ajax").serialize(),
                            beforeSend: function () {
                                wait.start();
                            },
                            success: function (result) {
                                wait.close();
                              
                                var obj = jQuery.parseJSON( result );
                             
                                var oTable = $('#tblListado').dataTable();
                                oTable.fnDestroy(); 
    
                                $("#tbContenedorListado").html(obj.html);
                             
                                aplicarDataTable('tblListado');
    
                                $("#dv_contenedor_listado").show("slide", {
                                    direction: 'left'
                                }, 500);

                                $("#txtFechaIni_h").val(fecha_ini);
                                $("#txtFechaFin_h").val(fecha_fin);

                                $("#slc_empleado_h").val(empleado);
                                $("#slc_tip_incapacidad_h").val(tipo_incapacidad);

                                $(".print").show();
    
                            }
                        });
                    }
            );
    
        });
    
    });
    
    function aplicarDataTable(idTabla) {
        $('#' + idTabla).dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 10,
            "bLengthChange": false,
            "bDestroy": true,
            "fnInitComplete": function (oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    }
    