$(document).ready(function () {
    
        $(".select").select2({placeholder : "Seleccione"});

        $(".datePicker").datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            closeText: 'Cerrar',
            currentText: 'Hoy'
        });

        $("#reporte").validate({
            rules: {
               
            },
            errorPlacement: function (error, element) {
                var nombre = $(element).attr("id");
                $("#" + nombre + "_error").html(error);
                crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
            },
            submitHandler: function (form){

                $("#filtro_inicio").val($("#txtFechaIni").val());
                $("#filtro_fin").val( $("#txtFechaFin").val());

                var fecha_ini =  $("#filtro_inicio").val();
                var fecha_fin = $("#filtro_fin").val();

                var area 		= $("#filtro_area").val();
                var nombre_area	= $("#filtro_area_nombre").val();

                $("#filtro_area").val(area);
                $("#filtro_area_nombre").val(nombre_area);

                if (fecha_ini == '' || fecha_fin == '') {
                    crear_alerta('error', 'Reporte de retiro de personal', 'Fechas son obligatorias.');
                    return false;
                }

                if (!validarPeriodo(fecha_ini, fecha_fin)) {
                        crear_alerta('error', 'Reporte de retiro de personal', 'Verifique el período de las fechas.');
                        return false;
                }
                
                form.submit();
            }
        });
    
        $("#btnConsultar").click(function(){
            event.preventDefault();
            
            var fecha_ini = $("#txtFechaIni").val();
            var fecha_fin = $("#txtFechaFin").val();

            var empleado = $("#slc_empleado").val();

            if (fecha_ini == '' || fecha_fin == '') {
                crear_alerta('error', 'Reporte de Control del uso de tiempo compensatorio', 'Fechas son obligatorias.');
                return false;
            }
    
            if (!validarPeriodo(fecha_ini, fecha_fin)) {
                    crear_alerta('error', 'Reporte de Control del uso de tiempo compensatorio', 'Verifique el período de las fechas.');
                    return false;
            }

            if (empleado == '' || empleado == '') {
                crear_alerta('error', 'Reporte de Control del uso de tiempo compensatorio', 'Empleado obligatorio.');
                return false;
            }
            
            $("#dv_contenedor_listado").hide('slide', {
                direction: 'right'
            },
                    400, function () {
                        $.ajax({
                            type: 'post',
                            url: window.gSateliteWhite.baseUrl('acciones_personal/consultas/consulta_tiempo_permisos/1'),
                            data: $("#reporte_ajax").serialize(),
                            beforeSend: function () {
                                wait.start();
                            },
                            success: function (result) {
                                wait.close();
                              
                                var obj = jQuery.parseJSON( result );

                                $("#tbContenedorListado").html(obj.html);
                             
    
                                $("#dv_contenedor_listado").show("slide", {
                                    direction: 'left'
                                }, 500);

                                $("#txtFechaIni_h").val(fecha_ini);
                                $("#txtFechaFin_h").val(fecha_fin);

                                $("#slc_empleado_h").val(empleado);

                                $(".print").show();
    
                            }
                        });
                    }
            );
    
        });
    
    });
    
