<script type="text/javascript">
    $(document).ready(function() {
        gSateliteWhite.jsDatePicker();
        $("#_monto").numeric();
        $("#_cuenta").select2({
            placeholder: "Cuenta Bancaria"
        });
        $("#_cuenta").attr('disabled', 'disabled');

        $("#tipo_btn").val(1);
        $("#btnGuardar").mouseover(function(event) {
            $("#tipo_btn").val(1);
        });

        $("#btnVolver").mouseover(function(event) {
            $("#tipo_btn").val(2);
        });

        $("#_tipo").select2({
            placeholder: "Tipo de Operación"
        }).change(function() {
            if ($("#_tipo option:selected").attr('transaccion') == 1) {
                $("#_destino2").show(250);
                $("#_destino option:first").text("Seleccione Cuenta Bancaria Destino");
                $("#_destino").select2({
                    placeholder: "Cuenta Bancaria Destino"
                });
            } else {
                $("#_destino2").hide('slow');
            }
        });

        $("#frm_tra_add").validate({
            ignore: null,
            ignore: 'input[type="hidden"]',
            rules: {
                tra_tipo: {
                    required: true,
                    min: 1
                },
                cub_id: {
                    required: true,
                    min: 1
                },
                operacion: {
                    required: true
                },
                fecha: {
                    required: true,
                    date: true
                },
                monto: {
                    required: true,
                    number: true
                }

            },
            errorPlacement: function(error, element) {
                if (element.attr('name') == 'cub_id' || element.attr('name') == 'tra_tipo') {
                    $(element).next().append(error);
                } else {
                    error.insertAfter(element);
                }
            },
            messages: {
                operacion: "Descripción Obligaria",
                fecha: "Fecha Obligaria",
                monto: "Monto Obligario",
                cub_id: "Seleccione un elemento",
                tra_tipo: "Seleccione un elemento"
            },
            submitHandler: function(form) {
                wait.start();
                form.submit();
            }
        });
    });

    function comprobar_cantidad() {
        var monto = $("#_monto").val();
        var cuenta = $("#cub_id").val();
        var tipo = $("#_tipo").val();
        if ($("#_monto").val() != '') {
            $.ajax({
                type: "POST",
                dataType: 'json',
                url: "<?php echo base_url() ?>utm/transacciones/comprobar_monto",
                data: {
                    cuenta: cuenta,
                    monto: monto,
                    tipo: tipo
                },
                success: function(data) {
                    if (data.resp == 1) {
                        crear_alerta('error', 'Error', 'El Monto a ejecutar es mayor del disponible.');
                        $("#_monto").val('');
                    }
                }
            });
        }
    }
</script>
<style type="text/css">
    .form-label {
        min-width: 170px;
        max-width: 170px;
    }
</style>
<?php if ($ver != '') { ?>
    <h3><b>&nbsp;&nbsp;&nbsp;&nbsp;Ver Transacción</b></h3>
<?php } ?>
<form action="<?php echo base_url() ?>utm/transacciones/actualizar_transaccion" autocomplete="off" method="post" id="frm_tra_add">
    <div class="row-fluid">
        <div class="span12">
            <div class="box hover">
                <div class="title">
                    <h4>
                        <span>Cuenta</span>
                    </h4>
                </div>
                <div class="content">
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span4" style="text-align:left;">Cuenta Bancaria: <b style="color:red">*</b></label>
                                <?php // echo form_dropdown('cub_id',$cuentas,$cub,'id="_cuenta" class="nostyle span8"') //Dropdown de cuentas bancarias 
                                ?>
                                <div class="span8">
                                    <input type="text" name="cuenta" id="cuenta" value="<?php echo $cub_selec; ?>" readonly <?php echo $ver; ?>>
                                    <input type="hidden" name="cub_id" id="cub_id" value="<?php echo $cub; ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span4" style="text-align:left;">Tipo de Transacción: <b style="color:red">*</b></label>
                                <select name="tra_tipo" id="_tipo" onchange="$('#tipo_tran_error').text('');" class="nostyle span8" style="display: none;" <?php echo $ver; ?>>
                                    <option value="0" selected="selected">Seleccione</option>
                                    <?php
                                    foreach ($tipos as $key => $value) { ?>
                                        <option value="<?php echo $value['ttb_id']; ?>" transaccion="<?php echo $value['ttb_transferencia']; ?>" <?php if ($value['ttb_id'] == $id_ttb) {
                                                                                                                                                        echo "selected";
                                                                                                                                                    } ?>><?php echo $value['ttb_nombre']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid" id="_destino2" style="display:none;">
                        <label class="form-label span4" style="text-align:left;">Cuenta destino:</label>
                        <p><?php echo form_dropdown('cub_destino', $cuentas, '0', 'id="_destino" class="nostyle span8" ' . $ver) ?></p>
                        <br />
                        <br />
                    </div>
                </div> <!-- Fi div content -->
            </div>
        </div> <!-- Fin div span12 -->
        <div class="span12">
            <div class="box">
                <div class="title">
                    <h4>
                        <span>Detalle</span>
                    </h4>
                </div>
                <div class="content">
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span4" style="text-align:left;">Fecha de registro: <b style="color:red">*</b></label>
                                <div class="span8">
                                    <input id="_fecha" name="fecha" type="text" placeholder="Fecha " value="<?php echo date('Y-m-d', strtotime($transaccion[0]['tra_fecha'])); ?>" <?php echo $ver; ?> />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span4" style="text-align:left;">Descripción: <b style="color:red">*</b></label>
                                <div class="span8">
                                    <input id="_operacion" name="operacion" type="text" maxlength="300" placeholder="Descripción " value="<?php echo $transaccion[0]['tra_operacion']; ?>" <?php echo $ver; ?> />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span4" style="text-align:left;">Monto: <b style="color:red">*</b></label>
                                <div class="span8">
                                    <p><input id="_monto" class="soloNumeros" extras="." name="monto" type="text" placeholder="Monto" value="<?php echo str_replace('-', '', $transaccion[0]['tra_monto']); ?>" <?php echo $ver; ?> /></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span4" style="text-align:left;">Comprobante:</label>
                                <div class="span8">
                                    <p><input id="comprobante" name="comprobante" type="text" maxlength="100" placeholder="Comprobante" value="<?php echo $transaccion[0]['tra_comprobante']; ?>" <?php echo $ver; ?> /></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-field-box odd  span12">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span2">Aplicar transacción: </label>
                                <div class="span3">
                                    <input type="checkbox" id="aplicar" name="aplicar" class="nostyle ibuttonCheck" <?php if (($transaccion[0]['tra_aplicar']) == 1) {
                                                                                                                        echo "checked=checked";
                                                                                                                    } ?> <?php echo $ver; ?>>
                                    <br>
                                    <input type="hidden" name="tipo_btn" id="tipo_btn">
                                    <input type="hidden" name="id_trans" id="id_trans" value="<?php echo $id_trans; ?>">
                                </div>
                            </div>
                        </div>
                    </div> <!-- Aplicar transacción -->
                    <br><br>
                    <?php if ($ver == '') { ?>
                        <div class="form-actions">
                            <button type="submit" id="btnGuardar" onmouseover="comprobar_cantidad();" class="btn btn-success icomoon-icon-checkmark white"> Actualizar</button>
                            <button type="submit" id="btnVolver" onmouseover="comprobar_cantidad();" class="btn btn-success icomoon-icon-loop white"> Actualizar y volver a la lista</button>
                            <a onclick="wait.start();" href="<?= base_url('utm/cuentas/transacciones') ?>" class="btn btn-danger icomoon-icon-cancel-2 white"> Cancelar</a>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</form>