<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

echo "<h4>Ventas Realizadas $fecha</h4>";
echo '<table id="table" class="data_table">';
echo '<thead>';
echo '<th class="center" style="width: 20%;">Empleado</th>';
echo '<th class="center" style="width: 20%;">Caja</th>';
echo '<th class="center" style="width: 20%;">Contribuyente</th>';
echo '<th class="center" style="width: 25%;">Fecha</th>';
echo '<th class="center" style="width: 15%; text-align:right;">Monto cancelado</th>';
echo '</thead>';
echo '<tbody>';
if (count($rs) > 0) {
    foreach ($rs as $informacion) {
        echo '<tr>';
        echo '<td>' . $informacion['emp_apellidos'] . ", " . $informacion['emp_nombres'] . '</td>';
        echo '<td>' . $informacion['caja'] . '</td>';
        echo '<td>' . $informacion['contribuyente'] . '</td>';
        echo '<td>' . ucwords($informacion['fecha']) . '</td>';
        echo '<td>' . '<div style="display: inline; float:left;" >' . $simbolo . '</div><div style="display: inline; float:right;" >' . $informacion['monto'] . '</div></td>';
        echo '</tr>';
    }
} else {
    echo '<tr><td colspan="5" align="center" style="text-align:center;">Sin registros que mostrar</td></tr>';
}
echo '</tbody>';
echo '</table>';
?>

<!-- DETALLE DE LAS CAJAS APERTURADAS. -->
<br />
<h4>Detalles de Caja <?php echo $fecha; ?></h4>
<table id="table2" class="data_table">
    <thead>
        <tr>
            <th width="25%">
                Caja
            </th>
            <th width="40%">
                Empleado
            </th>
            <th width="20%">
                Monto Apertura
            </th>
            <th width="15%">
                Estado
            </th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($detalle_caja as $fila) {
            $estado = "Aperturada";
            if ($fila["cxu_estado"] == 0) {
                //preguntar el estado en que se encuentra actualmente la caja (preguntar si ha sido cerrada)
                $where = array(
                    'cxu_id_usu' => $fila['cxu_id_usu'],
                    'cxu_fecha_proceso' => $fila['cxu_fecha_proceso'],
                    'cxu_id_caj' => $fila['cxu_id_caj'],
                    'cxu_estado !=' => $fila["cxu_estado"]
                );
                $this->db->order_by('cxu_id', 'desc'); //seleccionar el ultimo registro al inicio de la consulta
                $consulta = $this->gsatelite->get_tabla('cxu_cajaxusuario', $where);
                if ($consulta[0]['cxu_tipo'] == 2) {
                    $estado = "Corte";
                } elseif ($consulta[0]['cxu_tipo'] == 3) {
                    $estado = "Cerrada";
                }
            }
        ?>
            <tr>
                <td>
                    <?php echo $fila["caj_nombre"]; ?>
                </td>
                <td>
                    <?php echo $fila["nombre_empleado"]; ?>
                </td>
                <td>
                    <div style="display: inline; float:left;"><?= $simbolo ?></div>
                    <div style="display: inline; float:right;"> <?php echo number_format($fila["cxu_monto"], 2); ?></div>
                </td>
                <td>
                    <?php echo $estado; ?>
                </td>
            </tr>
        <?php } ?>
        <?php
        if (count($detalle_caja) <= 0) {
            echo '<tr><td colspan="4" align="center" style="text-align:center;">Sin registros que mostrar</td></tr>';
        }
        ?>
    </tbody>
</table>