<script type="text/javascript">
  $(document).ready(function() {
    gSateliteWhite.jsDatePicker();

    $(document).on('change', '#datepicker1', function() {
      validar_fecha_inicio_fin('datepicker1', 'datepicker2');
    });

    $(document).on('change', '#datepicker2', function() {
      validar_fecha_inicio_fin('datepicker1', 'datepicker2');
    });

    $("#datepicker1,#datepicker2").attr('readonly', 'readonly');
    $("#bancos").select2();
    $("#cub").select2();
    $('#bancos').change(function() {
      banco_id = $('#bancos').val();

      if (banco_id != 0) {
        $.ajax({
          type: 'POST',
          url: '<?php echo base_url(); ?>' + 'utm/reporteria/obtener_cub',
          data: {
            banco_id: banco_id
          },
          success: function(data) {
            // $("#cub").select2('destroy');
            $('#cub').html('<option></option>' + data).select2('destroy').select2();
          }
        });
      } else {

        $('#cub').html('<option></option>').select2('destroy').select2();
      }
    });


    $('form[name="frm_banco"]').validate({
      ignore: null,
      ignore: 'input[type="hidden"]',
      rules: {
        fecha_a: {
          required: true,
        },
        fecha_b: {
          required: true,
        },
        bancos: {
          required: true,
          min: 1
        },
        cub: {
          required: true,
          min: 1
        }
      },
      errorPlacement: function(error, element) {
        if (element.attr('name') == 'bancos' || element.attr('name') == 'cub') {
          $(element).next().append(error);
        } else {
          error.insertAfter(element);
        }
      },
      messages: {
        bancos: {
          min: "seleccione un registro"
        },
        cub: {
          min: "seleccione un registro"
        }
      }
      // , submitHandler: function(form){
      //       // Codigo Comentado, para mostrar el reporte generado en un pdf en otra pestaña al usuario
      //       url= '<?= base_url('utm/reporteria/generar_libro_banco_pdf/1') ?>'; //+ "?" + $(form).serialize();

      //       $.ajax({
      //         type: 'POST',
      //         url: url,
      //         data: {bancos:$('#bancos').val(), cub:$('#cub').val(), fecha_a: $('#datepicker1').val(), fecha_b: $('#datepicker2').val(), header:1},
      //         success: function(contenido){
      //           $.fancybox({
      //             'type': 'iframe',
      //             'content': contenido
      //           });
      //         }
      //       });
      //  }
    });

  });
</script>
<style type="text/css">
  .span3 {
    min-width: 160px;
    max-width: 160px;
  }
</style>
<form name="frm_banco" target="_blank" action="<?php echo base_url(); ?>utm/reporteria/generar_libro_banco_pdf/1" method="post">
  <input type="hidden" name="reporte" value="1">
  <input type="hidden" name="tipo_reporte" value="pdf">
  <input type="hidden" name="trans_aplicar" value="1">
  <div class="row-fluid">
    <div class="span12">
      <div class="box hover">
        <div class="title">
          <h4>Reporte de transacciones no aplicadas</h4>
        </div>
        <div class="content">
          <div class="form-row row-fluid">
            <div class="span12">
              <div class="row-fluid">
                <label class="form-label span3">Seleccione banco:<span style="color:red;">*</span></label>
                <?php
                $select = $this->gsatelite->get_dropdown('ban_banco', 'ban_nombre', 'bancos', '', set_value('bancos'), 'id="bancos" class="nostyle span8"');
                echo $select;
                ?>
              </div>
              <div class="span3" id="bancos_error" style="color:red;text-align:right"></div>
            </div>
          </div>
          <div class="form-row row-fluid">
            <div class="span12">
              <div class="row-fluid">
                <label class="form-label span3">Cuentas bancarias:<span style="color:red;">*</span></label>
                <select id='cub' name='cub' placeholder="Seleccione" class="nostyle span8">
                  <option></option>
                </select>
              </div>
              <div class="span3" id="bancos_error" style="color:red;text-align:right"></div>
            </div>
          </div>
          <div class="form-row row-fluid">
            <div class="span12">
              <div class="row-fluid">
                <label class="form-label span3">Fecha inicio:<span style="color:red;">*</span></label>
                <div class="form-input-box">
                  <div class="span6 controls">
                    <input type='text' name='fecha_a' id='datepicker1' class="span8" value="<?php echo ($this->input->post('fecha_a')) ? $this->input->post('fecha_a') : date('Y-m-d'); ?>" />
                  </div>
                </div>
              </div>
              <div class="span3" id="bancos_error" style="color:red;text-align:right"></div>
            </div>
          </div>
          <div class="form-row row-fluid">
            <div class="span12">
              <div class="row-fluid">
                <label class="form-label span3">Fecha fin:<span style="color:red;">*</span></label>
                <div class="form-input-box">
                  <div class="span6 controls">
                    <input type='text' name='fecha_b' id='datepicker2' class="span8" value="<?php echo ($this->input->post('fecha_b')) ? $this->input->post('fecha_b') : date('Y-m-d'); ?>" />
                  </div>
                </div>
              </div>
              <div class="span3" id="bancos_error" style="color:red;text-align:right"></div>
            </div>
          </div>
          <div class="form-actions">
            <center><button type="submit" class="btn btn-primary">Generar PDF</button></center>
          </div>
        </div>
      </div>
    </div>
  </div>
</form>