<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="11">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?>
                        Reporte de Retención de Cheques
                    </h4>
                </td>
            </tr>
            <tr>
                <td align="center" colspan="11">
                    <h4>
                        Período: <?php echo date_format(date_create($fecha_inicio), 'd-m-Y') ?> al <?php echo date_format(date_create($fecha_fin), 'd-m-Y') ?>
                    </h4>
                </td>
            </tr>
            <?php if ($proveedor != '') { ?>
                <tr>
                    <td align="center" colspan="11">
                        <h4>
                            Proveedor: <?= $proveedor ?>
                        </h4>
                    </td>
                </tr>
            <?php } ?>
            <?php if ($nit != '') { ?>
                <tr>
                    <td align="center" colspan="11">
                        <h4>
                            Nit: <?= $nit ?>
                        </h4>
                    </td>
                </tr>
            <?php } ?>
        </table>
    </div>
<?php } ?>
<?php if ($tipo_reporte != '') { ?>
    <table border="1px" width="100%" id="tblListado" class="dynamicTable responsive display table table-bordered" aria-describedby="table_2_info">
        <thead>
            <tr>
                <th width="9%"><b>Numero de cheque</b></th>
                <th width="9%"><b>Banco</b></th>
                <th width="7%"><b>Tipo</b></th>
                <th width="9%"><b>Fecha</b></th>
                <th width="17%"><b>Nombre</b></th>
                <th width="12%"><b>NIT</b></th>
                <th width="6%"><b>No. Doc</b></th>
                <!--<th>Partida</th>-->
                <th width="7%"><b>Monto</b></th>
                <th width="8%"><b>Monto Sujeto</b></th>
                <th width="8%"><b>Retención</b></th>
                <th width="7%"><b>Sub Total</b></th>
            </tr>
        </thead>
        <tbody>
        <?php } ?>
        <?php
        $periodo = "";
        if ($fecha_inicio != null && $fecha_fin != null) {

            $fecha_inicio = date("d-m-Y", strtotime($fecha_inicio));
            $fecha_fin = date("d-m-Y", strtotime($fecha_fin));

            $periodo = $fecha_inicio . "/" . $fecha_fin;
        }

        //Si la variable tipo reporte existe se declara la tabla
        $i = 1;
        ?>
        <?php
        foreach ($reporte as $row) : ?>
            <?php
            $nombre = $row['prv_nombre'];
            if ($row['prv_tipo_pers'] == 1) {
                $nombre .= " " . $row['prv_apellido'];
            }
            ?>
            <tr>
                <td width="9%"><?php echo $row['che_numero']; ?></td>
                <td width="9%"><?php echo $row['banco']; ?></td>
                <td width="7%">Cheques</td>
                <td width="9%"><?php echo formatear_fecha("d-m-Y", $row['che_fecha']); ?></td>
                <td width="17%"><?php echo $nombre; ?></td>
                <td width="12%"><?php echo $row['dcp_valor']; ?></td>
                <td width="6%"><?php echo $row['dpv_numero_documento']; ?></td>
                <!--<td><?php ?></td>-->
                <td width="7%"><?php echo $simbolo . number_format($row['dch_valor'], 2); ?></td>
                <td width="8%"><?php echo $simbolo . number_format($row['dch_retencion'], 2); ?></td>
                <td width="8%"><?php echo $simbolo . number_format($row['dch_retencion_calculada'], 2); ?></td>
                <td width="7%"><?php echo $simbolo . number_format($row['dch_subtotal'], 2); ?></td>
            </tr>
        <?php
            $i++;
        endforeach;
        $j = 1;
        foreach ($registros_nota as $row2) : ?>

            <tr>
                <td width="9%"><?php echo $row2['referencia']; ?></td>
                <td width="9%"><?php echo $row2['banco']; ?></td>
                <td width="7%">Nota de abono</td>
                <td width="9%"><?php echo date_format(date_create($row2['nta_fecha']), 'd-m-Y'); ?></td>
                <td width="17%"><?php echo $row2['proveedor'] ?></td>
                <td width="12%"><?php echo $row2['valor']; ?></td>
                <td width="6%"><?php echo $row2['numero']; ?></td>
                <td width="7%"><?php echo $simbolo . number_format($row2['valor'], 2); ?></td>
                <td width="8%"><?php echo $simbolo . number_format($row2['ret'], 2); ?></td>
                <td width="8%"><?php echo $simbolo . number_format($row2['calculada'], 2); ?></td>
                <td width="7%"><?php echo $simbolo . number_format($row2['subtotal'], 2); ?></td>
            </tr>
        <?php
            $j++;
        endforeach;
        ?>
        <?php if ($tipo_reporte != '') { ?>
    </table>
    </tbody>
<?php } ?>