<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 100% !important;
        }

        .tabla th {
            border: none;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: none;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: none;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
    <?php
    if ($tipo_reporte == 'pdf') {   ?>
        <style type="text/css">
            .line-pdf {
                font-size: 8px !important;
            }

            .line-money {
                text-align: right !important;
            }
        </style>
<?php   }
} ?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4 class="">
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte resumen de conciliaciones bancarias
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } else if ($tipo_reporte == 'pdf') { ?>


<?php } ?>

<?php
$meses = [1 => 'Enero', 2 => 'Febrero', 3 => 'Marzo', 4 => 'Abril', 5 => 'Mayo', 6 => 'Junio', 7 => 'Julio', 8 => 'Agosto', 9 => 'Septiembre', 10 => 'Octubre', 11 => 'Noviembre', 12 => 'Diciembre'];
$periodo = "";
if ($fecha_inicio != null && $fecha_fin != null) {

    $fecha_inicio = date("d-m-Y", strtotime($fecha_inicio));
    $fecha_fin = date("d-m-Y", strtotime($fecha_fin));

    $periodo = $fecha_inicio . "/" . $fecha_fin;
}

//Si la variable tipo reporte existe se declara la tabla
$i = 1;
$registros = 1;
$saldo = 0.00;
$saldo_empresa = 0.00;
$saldo_banco = 0.00;
$decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
foreach ($reporte as $row) :
    if ($registros == 1) {
        //$saldo guarda el saldo de la cuenta, solo la primera vez que el se recorre el bucle
        $saldo = $row['saldo'];
    }
    if ($tipo_reporte != '') {
        if ($registros == 1) {
?>
            <table class="">
                <tr>
                    <td colspan="3"></td>
                </tr>
                <tr>
                    <td class="line-pdf" style="width: 12%;"><b>Cuenta:</b></td>
                    <td class="line-pdf" style="text-align: left;"><?php echo $cuenta; ?></td>
                    <td class="line-pdf" style="width: 10%;"><b>Período:</b></td>
                    <td class="line-pdf" style="text-align: left;"><?php echo $periodo; ?></td>
                </tr>
            </table>
            <div></div>
        <?php  } ?>
        <?php if ($i == 1) {    ?>
            <table class="tabla">
                <tr>
                    <th style="width: 30%;" class="line-pdf">Tipo de transacción</th>
                    <th class="line-pdf" style="width: 25%;">Bancos</th>
                    <th class="line-pdf" style="width: 25%;"><?= $this->gsatelite->get_parametro('SYS_EMPRESA'); ?></th>
                    <th class="line-pdf" style="width: 10%;">Saldos</th>
                </tr>
                <tbody>
                    <?php
                    //SALDOS
                    $saldo_bank = 0;
                    $saldo_emp = 0;
                    $saldo_ini = 0;
                    if (count($saldos) > 0) {
                        foreach ($saldos as $value) {
                            $saldo_ini = $value['cub_saldo_inicial'];
                            $saldo_bank += ($value['aplicar'] == 1 && ($value['ttb_deposito'] == 1 || $value['ttb_transferencia'] == 1)) ? $value['tra_monto'] : 0;
                            $saldo_emp += ($value['tra_aplicar'] == 0) ? $value['tra_monto'] : 0;
                    ?>
                        <?php   }
                        $saldo_bank += $saldo_ini;
                        $saldo_emp += $saldo_ini;
                        ?>
                        <tr>
                            <td class="line-pdf" style="text-align: left;">Saldos al <?= date("d", strtotime($fecha_inicio)) . ' de ' . $meses[date('n', strtotime($fecha_inicio))] . ' ' . date('Y', strtotime($fecha_inicio)) ?></td>
                            <td style="text-align: right;"><?= number_format($saldo_bank, $decimales); ?></td>
                            <td style="text-align: right;"><?= number_format($saldo_emp, $decimales); ?></td>
                            <td class="line-pdf line-money"></td>
                        </tr>
                    <?php       } else {  ?>
                        <tr>
                            <td class="line-pdf" style="text-align: left;">Saldos al <?= date("d", strtotime($fecha_inicio)) . ' de ' . $meses[date('n', strtotime($fecha_inicio))] . ' ' . date('Y', strtotime($fecha_inicio)) ?></td>
                            <td style="text-align: right;"></td>
                            <td style="text-align: right;"></td>
                            <td class="line-pdf line-money"></td>
                        </tr>
            <?php       }
                }
            }
            $saldo_banco += $row['saldo_banco'];
            $saldo_empresa += $row['saldo_empresa'];            ?>
            <tr>
                <td style="text-align: left;" class="line-pdf"><?= $row['ttb_nombre'] ?></td>
                <td class="line-pdf" style="text-align: right;"><?php
                                                                if ($row['saldo_banco'] < 0) {
                                                                    echo number_format(($row['saldo_banco']), $decimales); //Tenia un *-1
                                                                } else if ($row['saldo_banco'] > 0) {
                                                                    echo number_format($row['saldo_banco'], $decimales);
                                                                } ?></td>
                <td class="line-pdf" style="text-align: right;"><?php
                                                                if ($row['saldo_empresa'] < 0) {
                                                                    echo number_format(($row['saldo_empresa']), $decimales); //Tenia un *-1
                                                                } else {
                                                                    echo number_format($row['saldo_empresa'], $decimales);
                                                                } ?></td>
                <td class="line-pdf"></td>
            </tr>
            <?php
            $i++;            ?>
            <?php
            //Si la variable tipo reporte existe se declara la tabla
            if ($tipo_reporte != '' && $tipo_reporte == 'pdf') {
                if ($i == 40) {
            ?>
                </tbody>
            </table>
            <br style="page-break-after: always;" />
        <?php
                    $i = 1;
                } else if ($registros == count($reporte)) {
        ?>
            </tbody>
            </table>
    <?php
                }
            }
            $registros++;
        endforeach;
        if ($tipo_reporte != '') {  ?>
    <br> <br>
    <table class="tabla">
        <tr>
            <td style="width: 30%;text-align: left;font-weight: bold;" class="line-pdf">Saldos Conciliados</td>
            <td class="line-pdf" style="width: 25%;text-align: right; font-weight: bold;"><?php
                                                                                            $saldo_banco += $saldo_bank;
                                                                                            if ($saldo_banco < 0) {
                                                                                                echo number_format(($saldo_banco), $decimales); //Tenia un *-1
                                                                                            } else {
                                                                                                echo number_format($saldo_banco, $decimales);
                                                                                            }
                                                                                            ?></td>
            <td class="line-pdf" style="width: 25%;text-align: right; font-weight: bold;"><?php
                                                                                            $saldo_empresa = ($saldo_empresa); //Tenia un *-1
                                                                                            $saldo_empresa += $saldo_emp;
                                                                                            if ($saldo_empresa < 0) {
                                                                                                echo number_format(($saldo_empresa), $decimales); //Tenia un *-1    
                                                                                            } else {
                                                                                                echo number_format($saldo_empresa, $decimales);
                                                                                            }
                                                                                            ?></td>


            <td class="line-pdf" style="width: 15%;text-align: left;font-weight: bold;">
                <?php
                $temp_banco = ($saldo_banco < 0) ? ($saldo_banco) : $saldo_banco; //Tenia un *-1
                $dif = $saldo_empresa - $temp_banco;

                echo number_format($dif, $decimales);
                ?>
            </td>
        </tr>
    </table>
    <!-----SECCION DE FIRMAS------->
    <?php
            $data_firma = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_BANCO'));
    ?><br><br><br><br><br>
    <table>
        <tr>
            <td>
                <span>_______________________________</span><br>
                <span class="line-pdf">PREPARADO POR</span><br>
                <span class="line-pdf"><?= $data_firma->CONTADOR->NOMBRE; ?></span><br>
                <span class="line-pdf"><?= $data_firma->CONTADOR->CARGO; ?></span>
            </td>
            <td>
                <span>_______________________________</span><br>
                <span class="line-pdf">AUTORIZADO POR</span><br>
                <span class="line-pdf"><?= $data_firma->PROPIETARIO->NOMBRE; ?></span><br>
                <span class="line-pdf"><?= $data_firma->PROPIETARIO->CARGO; ?></span>
            </td>
        </tr>
    </table>

<?php } ?>