<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

if ($tipo_reporte != '') {
?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: left;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php
}

if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte Libro de Bancos
                    </h4>
                </td>
            </tr>
        </table>
    </div>
    <?php
}


$periodo = "";
if ($fecha_inicio != null && $fecha_fin != null) {

    $fecha_inicio = date("d-m-Y", strtotime($fecha_inicio));
    $fecha_fin = date("d-m-Y", strtotime($fecha_fin));

    $periodo = $fecha_inicio . "/" . $fecha_fin;
}

//Si la variable tipo reporte existe se declara la tabla
$i = 1;
$registros = 1;
$saldo = $saldo_inicial;
$pagina = null;
foreach ($reporte as $row) {
    if ($tipo_reporte != '') {
        if ($registros == 1) {
            //Tabla Encabezado con datos
    ?>
            <table class="">
                <tr>
                    <td colspan="3"></td>
                </tr>
                <tr>
                    <td style="width: 12%;"><b>Cuenta:</b></td>
                    <td style="text-align: left;"><?php echo $cuenta['ban_nombre'] . ": " . $cuenta['cub_numero']; ?></td>
                    <td style="width: 10%;"><b>Período:</b></td>
                    <td style="text-align: left;"><?php echo $periodo; ?></td>
                </tr>
            </table>
            <div></div>
        <?php
        }

        if ($i == 1) {
            //Titulos de la tabla
        ?>
            <table class="tabla">
                <thead>
                    <tr>
                        <th>Fecha</th>
                        <th>Referencia</th>
                        <th>Tipo Transacción</th>
                        <th>Concepto</th>
                        <th>Partida</th>
                        <th>Abono</th>
                        <th>Retiro</th>
                        <th>Saldo</th>
                    </tr>
                </thead>
                <tbody>
                <?php
            }
        }
        if ($i == 1 && $registros == 1) {
            //Saldo inicial
                ?>
                <tr>
                    <td></td>
                    <td></td>
                    <td>Saldo Inicial</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($saldo_inicial, 2); ?></td>
                </tr>
            <?php
        }
        $monto_abono = null;
        $monto_retiro = null;
        if ($row['ttb_deposito'] == 1) {
            $saldo += $row['tra_monto'];
            $monto_abono = ($row['tra_monto'] < 0) ? $simbolo . '(' . number_format(($row['tra_monto'] * -1), 2) . ')' : $simbolo . number_format($row['tra_monto'], 2);
        } else if ($row['ttb_retiro'] == 1) {
            $saldo -= abs($row['tra_monto']);
            $monto_retiro = ($row['tra_monto'] < 0) ? $simbolo . '' . number_format(($row['tra_monto'] * -1), 2) . '' : $simbolo . number_format($row['tra_monto'], 2);
        }
        $monto_saldo = ($saldo < 0) ? $simbolo . '(' . number_format(($saldo * -1), 2) . ')' : $simbolo . number_format($saldo, 2);
        if ($row['che_numero'] != "") {
            $reference_op = 'Cheque #' . $row['che_numero'];
            $concepto_tra = $row['che_concepto'];
        } elseif ($row['nta_codigo'] != "") {
            $reference_op = 'Nta Abono #' . $row['nta_codigo'];
            $concepto_tra = $row['nta_concepto'];
        } else {
            $reference_op = ($row['abc_comprobante'] != "") ? 'Pago #' . $row['abc_comprobante'] : 'Remesa #' . $row['tra_comprobante'];
            $concepto_tra = "";
        }
            ?>
            <tr nobr="true">
                <td><span style="display: none;"><?php echo formatear_fecha('Ymd', $row['tra_fecha']); ?></span><?php echo date('d-m-Y', strtotime($row['tra_fecha'])); ?></td>
                <td><?php echo $reference_op; ?></td>
                <td><?php echo $row['tra_operacion']; ?></td>
                <td><?php echo $concepto_tra; ?></td>
                <td><?php echo $row['partida'] ?></td>
                <td style="text-align: right;"><?php echo $monto_abono; ?></td>
                <td style="text-align: right;"><?php echo $monto_retiro; ?></td>
                <td style="text-align: right;"><?php echo $monto_saldo; ?></td>
            </tr>
            <?php
            $i++;

            if ($tipo_reporte != '') {
                //Si la variable tipo reporte existe se declara la tabla
                if ($tipo_reporte == 'pdf') {
                    if ($i == 40 && $pagina == null) {
                        $pagina = 1;
            ?>
                </tbody>
            </table>
            <br style="page-break-after: always;" />
        <?php
                        $i = 1;
                    } elseif ($i == 45 && $pagina != null) {
        ?>
            </tbody>
            </table>
            <br style="page-break-after: always;" />
        <?php
                        $i = 1;
                    } elseif ($registros == count($reporte)) {
        ?>
            </tbody>
            </table>
        <?php
                    }
                } else {
                    if ($registros == count($reporte)) {
        ?>
            </tbody>
            </table>
<?php
                    }
                }
            }
            $registros++;
        } //endforeach;
?>