<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
        }
    </style>
<?php
}
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4><?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> <br /> Reporte de Cheques Emitidos </h4>
                </td>
            </tr>
        </table>
    </div>
<?php
}
$i = 1;
$periodo = "";
$total = 0.00;
if ($fecha_inicio != null && $fecha_fin != null) {
    $fecha_inicio = date("d-m-Y", strtotime($fecha_inicio));
    $fecha_fin = date("d-m-Y", strtotime($fecha_fin));
    $periodo = $fecha_inicio . " / " . $fecha_fin;
}
if ($tipo_reporte != '') {
?>
    <table class="">
        <tr>
            <td colspan="4"></td>
        </tr>
        <tr>
            <td style="width: 10%;"><b>Período:</b></td>
            <td style="text-align: left;"><?php echo $periodo; ?></td>
        </tr>
    </table>
    <div></div>
    <table class="tabla" width="100%">
        <thead>
            <tr>
                <th width="3%">#</th>
                <th width="16%">Banco</th>
                <th width="12%">Numero Cuenta</th>
                <th width="9%">Numero Cheque</th>
                <th width="9%">Fecha</th>
                <th width="17%">A favor de</th>
                <th width="16%">Concepto</th>
                <th width="8%">Estado</th>
                <th width="10%">Monto</th>
            </tr>
        </thead>
        <tbody>
            <?php
        }
        if (count($reporte) > 0) {
            foreach ($reporte as $k => $row) {
            ?>
                <tr nobr="true">
                    <td width="3%"><?php echo $i ?></td>
                    <td width="16%"><?php echo $row['ban_nombre']; ?></td>
                    <td width="12%" class="text"><?php echo $row['cub_numero']; ?></td>
                    <td width="9%" class="text"><?php echo $row['che_numero']; ?></td>
                    <td width="9%"><?php
                                    echo ($tipo_reporte != '') ? '' : '<span style="display: none;">' . formatear_fecha('Ymd', $row['che_fecha']) . '</span>';
                                    echo formatear_fecha('d-m-Y', $row['che_fecha']);
                                    ?></td>
                    <td width="17%"><?php echo $row['che_orden']; ?></td>
                    <td width="16%"><?php echo $row['che_concepto']; ?></td>
                    <td width="8%"><?php echo ($row['che_estado'] == 1) ? 'Activo' : 'Anulado'; ?></td>
                    <td width="10%" style="text-align: right;"><?php echo $simbolo . number_format($row['che_monto'], 2); ?></td>
                </tr>
            <?php
                $total += $row['che_monto'];
                $i++;
            }
        } else {
            if ($tipo_reporte != '') {
            ?>
                <tr>
                    <th colspan="*" style="text-align: center;font-weight: bold;">No se encontraron registros</th>
                </tr>
            <?php
            }
        }
        if ($tipo_reporte != '') {
            ?>
        </tbody>
        <?php if (count($reporte) > 0) {
        ?>
            <tfoot>
                <tr>
                    <th colspan="8" style="text-align:right;">Total <?= $simbolo ?></th>
                    <th style="text-align:right;"><?php echo number_format($total, 2); ?> </th>
                </tr>
            </tfoot>
        <?php
            } ?>
    </table>
<?php
        }
?>