<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if (isset($tipo_reporte) && $tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<?php if (isset($tipo_reporte) && $tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="10">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de libro bancos
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<?php if (isset($tipo_reporte) && $tipo_reporte == 'pdf') : ?>
    <style type="text/css">
        td {
            font-family: courier;
            font-size: 9px;
        }
    </style>
<?php endif; ?>
<!-- <h1></h1>
<br/>
<br/> -->
<?php
$fecha_a = formatear_fecha('d-m-Y', $fecha_a);
$fecha_b = formatear_fecha('d-m-Y', $fecha_b);
?>
<?php if (isset($tipo_reporte) && $tipo_reporte == 'pdf' || isset($tipo_reporte) && $tipo_reporte == 'excel') : ?>

    <table>
        <tr>
            <td>CUENTA N°: <?= $informacion_general[0]['cub_numero']; ?>
                <br />
                NOMBRE CUENTA: <?php echo $informacion_general[0]['cub_nombre']; ?>
                <br />
                BANCO: <?= $informacion_general[0]['ban_nombre']; ?>
            </td>
            <td>SALDO INICIAL: <?= $saldo_inicial ?>
                <br /><br />
                Periodo <?= 'De ' . $fecha_a  . ' hasta ' . $fecha_b ?>
            </td>
        </tr>
    </table>
    <br />
<?php endif; ?>

<!-- Comienza la cabecera -Opciona- -->
<?php if ($header > 0) { ?>
    <?php $tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO"); ?>
    <style type="text/css">
        table {
            margin: 0 auto;
        }

        td {
            text-align: center;
            font-family: arial;
        }

        .impar {
            background-color: #D7E5F7;
        }

        .par {
            background-color: #B9D5F7;
        }

        .fuente_titulo {
            font-family: <?php echo $tipo_fuente; ?>;
        }
    </style>
    <table align="center" cellpadding="0">
        <tr>
            <td align="left" width="20%">
                <?php
                $colspan = "";
                $colspan2 = 0;
                if (isset($columnas)) {
                    $colspan2 = "colspan='" . $columnas . "'";
                    $cols = $columnas - 1;
                    $colspan = "colspan='" . $cols . "'";
                }

                if ($titulo != 'Cotización') { ?>
                    <img src="<?php echo base_url(); ?>media/imagenes/sistema/<?php echo $this->gsatelite->get_parametro('SYS_LOGOTIPO') ?>.png" width="108px" height="48">
                <?php
                }
                ?>
            </td>
            <td width="65%" <?php echo $colspan; ?>>
                <br>

                <span style="font-size: 12px; font-weight: bold;" class="fuente_titulo">
                    <?php
                    echo $this->gsatelite->get_parametro('SYS_EMPRESA');

                    ?>
                </span>

                <h3>
                    <?php
                    echo $titulo;
                    ?>
                </h3>
            </td>
            <td align="right" width="15%"></td>
        </tr>
        <?php
        if ($colspan2 != '') {
            $colspan2 = $colspan2;
        } else {
            $colspan2 = 'colspan="3"';
        }
        if (empty($subtitulo)) {
        } else {


            echo '<tr> <td ' . $colspan . '> <span style="font-size: 8px; font-weight: normal;">';
            if (isset($subtitulo)) {
                echo $subtitulo;
            }
            echo '
                </span>
            </td>
        </tr>';
        }
        ?>
        <tr>
            <td <?php echo $colspan2; ?> style="text-align: right; size: 8;font-weight: bold;"></td>
        </tr>
        <tr>
            <td <?php echo $colspan2; ?> style="text-align: right; size: 8;font-weight: bold;"><?php echo date('d-m-Y H:i:s a'); ?></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
        </tr>
        <?php //} 
        ?>
    </table><br> <!-- Terminar la cabecera -->
<?php } ?>

<!-- <table id="tabla_resultados"> -->
<table border="1px" id="tblListado" class="dynamicTable responsive display table table-bordered" aria-describedby="table_2_info">
    <thead>
        <tr>
            <th>FECHA</th>
            <th>CHE / REM </th>
            <th colspan="3">CONCEPTO</th>
            <th>DEBE</th>
            <th>HABER</th>
            <th>SALDO </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td></td>
            <td></td>
            <td colspan="3"><strong>SALDO INICIAL</strong></td>
            <td></td>
            <td></td>
            <td><strong><?php echo $simbolo . number_format($saldo_inicial, 2); ?></strong></td>
        </tr>
        <?php
        $saldo = $saldo_inicial;
        $total_debe = 0;
        $total_haber = 0;
        $depo = 0;

        foreach ($informacion as $row) :
            //calulos de saldo
            $tipo = $row['id_ttb'];
            $m = $row['monto'];

            if ($m < 0) {
                $monto = abs($row['monto']);
            } else {
                $monto = $m;
            }

            if ($m < 0 && $tipo == 3) {
                $tipo = "tra_retiro";
                $monto = $monto = abs($row['monto']);
            } else if ($m > 0 && $tipo == 3) {
                $tipo = "tra_deposito";
                $monto = $m;
            }

            $total_debe += $debe = ($tipo == 6 || $tipo == 2 || $tipo == 'tra_retiro') ? $monto : 0;
            $total_haber += $haber = ($tipo == 1 || $tipo == 5 || $tipo == 'tra_deposito') ? $monto : 0;
            $saldo = $saldo + $row['monto'];
        ?>
            <tr>
                <td style="text-align: center;"><?= $row['fecha'] ?></td>
                <td style="text-align: center;"><?= $row['numero'] ?></td>
                <td colspan="3"><?= $row['concepto'] ?></td>

                <td style="text-align: right;"><?= number_format($debe, 2) ?></td>
                <td style="text-align: right;"><?= number_format($haber, 2) ?></td>
                <td style="text-align: right;"><?= number_format($saldo, 2) ?></td>
            </tr>
        <?php
        endforeach;
        ?>
    </tbody>
    <tfoot>
        <tr>
            <td colspan="5" style="text-align: right; font-weight: bold;">Total</td>
            <td style="text-align: right;"><strong><?php echo $simbolo . number_format($total_haber, 2); ?></strong></td>
            <td style="text-align: right;"><strong><?php echo $simbolo . number_format($total_debe, 2); ?></strong></td>
            <td style="text-align: right;"><strong><?php echo $simbolo . number_format($saldo, 2); ?></strong></td>
        </tr>
    </tfoot>
</table>