<?php
if ($tipo_reporte == 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
}
$tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");
if ($tipo_reporte != 'grid') {
?>
    <style type="text/css">
        .tabla {
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }

        th {
            font-weight: bold !important;
        }

        td {
            font-family: arial;
        }

        .fuente_titulo {
            font-family: <?php echo $tipo_fuente; ?>;
        }
    </style>
    <?php if ($tipo_reporte == 'excel') {
    ?>
        <table>
            <thead>
                <tr>
                    <th colspan="10">Listado de compras por proyecto</th>
                </tr>
            </thead>
        </table>
    <?php
    }
    ?>
    <table border="1" width="100%">
        <thead>
            <tr>
                <th width="4%">No.</th>
                <th>Banco</th>
                <th>Chequera</th>
                <th>No. cheque</th>
                <th>Fecha cheque</th>
                <th>Proyecto</th>
                <th>No. DPV</th>
                <th>A favor de</th>
                <th>Concepto</th>
                <th>Monto</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if (count($proyectos) > 0) {
                $num_pro = 1;
                $registro = array();
                $totales = 0;
                foreach ($proyectos as $key) {
                    $fecha = formatear_fecha('d-m-Y', $key['che_fecha']);
                    $totales += $key['total'];
            ?>
                    <tr>
                        <td width="4%"><?php echo $num_pro++; ?></td>
                        <td><?= $key['ban_nombre'] ?></td>
                        <td><?= $key['chequera'] ?></td>
                        <td><?= $key['che_numero'] ?></td>
                        <td><?= $fecha ?></td>
                        <td><?= $key['proyecto'] ?></td>
                        <td><?= $key['Ndocumento'] ?></td>
                        <td><?= $key['che_orden'] ?></td>
                        <td><?= $key['che_concepto'] ?></td>
                        <td><?= number_format($key['total'], 2) ?></td>
                    </tr>
                <?php } ?>
                <tr>
                    <td colspan="9" style="text-align: right;">Totales</td>
                    <td><?= number_format($totales, 2) ?></td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
<?php
} else {

?>
    <!--Datos de la grid-->
    <table border="1" style="font-size:12.5px;color:black;" class="responsive table table-bordered contenedor" id="datagried" width="100%" name="datagried">
        <thead>
            <tr>
                <th>No.</th>
                <th>Banco</th>
                <th>Chequera</th>
                <th>No. cheque</th>
                <th>Fecha cheque</th>
                <th>Proyecto</th>
                <th>No. DPV</th>
                <th>A favor de</th>
                <th>Concepto</th>
                <th>Monto</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if (count($proyectos) > 0) {
                $num_pro = 1;
                $registro = array();
                $totales = 0;
                foreach ($proyectos as $key) {
                    $fecha = formatear_fecha('d-m-Y', $key['che_fecha']);
                    $totales += $key['total'];
            ?>
                    <tr>
                        <td><?php echo $num_pro++; ?></td>
                        <td><?= $key['ban_nombre'] ?></td>
                        <td><?= $key['chequera'] ?></td>
                        <td><?= $key['che_numero'] ?></td>
                        <td><?= $fecha ?></td>
                        <td><?= $key['proyecto'] ?></td>
                        <td><?= $key['Ndocumento'] ?></td>
                        <td><?= $key['che_orden'] ?></td>
                        <td><?= $key['che_concepto'] ?></td>
                        <td><?= number_format($key['total'], 2) ?></td>
                    </tr>
                <?php } ?>
        <tfoot style="border: 1px solid #c4c4c4">
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td>Totales</td>
            <td><?= number_format($totales, 2) ?></td>
        </tfoot>
    <?php } ?>
    </tbody>
    </table>
<?php } ?>