<?php

$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

if ($tipo_reporte != '') {
?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: left;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php
}

if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte Libro de Bancos
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php
}

$periodo = "";
if ($fecha_inicio != null && $fecha_fin != null) {
    $fecha_inicio = formatear_fecha("d-m-Y", $fecha_inicio);
    $fecha_fin = formatear_fecha("d-m-Y", $fecha_fin);
    $periodo = $fecha_inicio . " / " . $fecha_fin;
}

//Si la variable tipo reporte existe se declara la tabla
$i = 1;
$registros = 1;
$saldo = $saldo_inicial;
$pagina = null;
if ($tipo_reporte != '') {
?>
    <table>
        <tr>
            <td style="width: 12%;"><b>Cuenta:</b></td>
            <td style="text-align: left;"><?php echo $cuenta['ban_nombre'] . ": " . $cuenta['cub_numero']; ?></td>
            <td style="width: 10%;"><b>Período:</b></td>
            <td style="text-align: left;"><?php echo $periodo; ?></td>
        </tr>
    </table>
    <div></div>
    <table class="tabla">
        <thead>
            <tr>
                <th width="9%">Fecha</th>
                <th width="13%">Referencia</th>
                <th width="13%">Tipo Transacción</th>
                <th width="13%">Concepto</th>
                <th width="13%">Partida</th>
                <th width="13%">Abono</th>
                <th width="13%">Retiro</th>
                <th width="13%">Saldo</th>
            </tr>
        </thead>
        <tbody>
        <?php
    }
    if (count($reporte) > 0) {
        ?>
            <tr>
                <td width="9%"></td>
                <td width="13%"></td>
                <td width="13%">Saldo Inicial</td>
                <td width="13%"></td>
                <td width="13%"></td>
                <td width="13%"></td>
                <td width="13%"></td>
                <td width="13%" style="text-align: right;"><?php echo $simbolo . number_format($saldo_inicial, 2); ?></td>
            </tr>
            <?php
            foreach ($reporte as $key => $row) {
                $monto_abono = null;
                $monto_retiro = null;
                if ($row['ttb_deposito'] == 1) {
                    $saldo += $row['tra_monto'];
                    $monto_abono = ($row['tra_monto'] < 0) ? $simbolo . '(' . number_format(($row['tra_monto'] * -1), 2) . ')' : $simbolo . number_format($row['tra_monto'], 2);
                } else if ($row['ttb_retiro'] == 1) {
                    $saldo -= abs($row['tra_monto']);
                    $monto_retiro = ($row['tra_monto'] < 0) ? $simbolo . '' . number_format(($row['tra_monto'] * -1), 2) . '' : $simbolo . number_format($row['tra_monto'], 2);
                }
                $monto_saldo = ($saldo < 0) ? $simbolo . '(' . number_format(($saldo * -1), 2) . ')' : $simbolo . number_format($saldo, 2);
                if ($row['che_numero'] != "") {
                    $reference_op = 'Cheque #' . $row['che_numero'];
                    $concepto_tra = $row['che_concepto'];
                } elseif ($row['nta_codigo'] != "") {
                    $reference_op = 'Transferencia Bancaria #' . $row['nta_codigo'];
                    $concepto_tra = $row['nta_concepto'];
                } else {
                    $reference_op = ($row['abc_comprobante'] != "") ? 'Ingreso por Pago #' . $row['abc_comprobante'] : 'Transacción #' . $row['tra_comprobante'];
                    $concepto_tra = ($row['abc_comprobante'] != "") ? 'Pago #' . $row['abc_comprobante'] . ' de fecha ' . formatear_fecha('d-m-Y', $row['abc_fecha']) : 'Transacción #' . $row['tra_comprobante'] . ' de fecha ' . formatear_fecha('d-m-Y', $row['tra_fecha']);
                }
            ?>
                <tr nobr="true">
                    <td width="9%">
                        <?php if ($tipo_reporte == '') { ?><span style="display: none;"><?php echo formatear_fecha('Ymd', $row['tra_fecha']); ?></span><?php } ?>
                        <span><?php echo date('d-m-Y', strtotime($row['tra_fecha'])); ?></span>
                    </td>
                    <td width="13%"><?php echo $reference_op; ?></td>
                    <td width="13%"><?php echo $row['tra_operacion']; ?></td>
                    <td width="13%"><?php echo $concepto_tra; ?></td>
                    <td width="13%"><?php echo $row['partida'] ?></td>
                    <td width="13%" style="text-align: right;"><?php echo $monto_abono; ?></td>
                    <td width="13%" style="text-align: right;"><?php echo $monto_retiro; ?></td>
                    <td width="13%" style="text-align: right;"><?php echo $monto_saldo; ?></td>
                </tr>
            <?php
            }
        } else {
            if ($tipo_reporte != '') {
            ?>
                <tr>
                    <td colspan="8" style="text-align: center;"><b>No se encontraron registros</b></td>
                </tr>
            <?php
            }
        }
        if ($tipo_reporte != '') {
            ?>
        </tbody>
    </table>
<?php
        }

?>