<?php

$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

/**
 * @author alexis
 * @copyright 2014
 */
?>
<?php
$p = ($tipo_reporte == 'pdf') ? true : false;
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table id="datagried" width="100%">
            <tr>
                <td align="center" colspan="10">
                    <h4>
                        <?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> <br />
                        Reporte de control de ingresos
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<style type="text/css">
    td {
        font-family: arial;
    }
</style>
<?php if ($tipo_reporte == 'pdf' || $tipo_reporte == 'excel') { ?>
    <table width="100%">
        <tr>
            <td>Fecha inicio: <?php echo $fecha_desde; ?></td>
            <td>Fecha fin: <?php echo $fecha_hasta; ?></td>
        </tr>
    </table>
<?php } ?>
<table border="1px" width="100%" class="dynamicTable responsive display table table-bordered dataTable">
    <thead>
        <tr style="font-weight: bold;">
            <th <?= ($p) ? 'width="5%"' : ''; ?>>Nº</th>
            <th <?= ($p) ? 'width="12%"' : ''; ?>>Comprobante</th>
            <th <?= ($p) ? 'width="13%"' : ''; ?>>Fecha Transacción</th>
            <th <?= ($p) ? 'width="13%"' : ''; ?>>No. CTA</th>
            <th <?= ($p) ? 'width="15%"' : ''; ?>>Nombre Cuenta</th>
            <th <?= ($p) ? 'width="13%"' : ''; ?>>Tipo Transacción</th>
            <th <?= ($p) ? 'width="18%"' : ''; ?>>Descripción</th>
            <th <?= ($p) ? 'width="11%"' : ''; ?>>Valor</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $cont = 0;
        $total   = 0;
        foreach ($transacciones as $row) {
            $cont++;
            $total += $row->monto;
            $m = $row->monto;
        ?>
            <tr nobr="true">
                <td <?= ($p) ? 'width="5%"' : ''; ?> style="text-align: left;"><?= $cont ?></td>
                <td <?= ($p) ? 'width="12%"' : ''; ?> style='mso-number-format:"\@";'><?= $row->tra_comprobante ?></td>
                <td <?= ($p) ? 'width="13%"' : ''; ?>>
                    <?php if ($tipo_reporte == '') { ?>
                        <span style="display: none;visibility: hidden;"><?= formatear_fecha('Ymd', $row->fecha) ?></span>
                    <?php } ?>
                    <span><?= formatear_fecha('d-m-Y', $row->fecha) ?></span>
                </td>
                <td <?= ($p) ? 'width="13%"' : ''; ?> style='mso-number-format:"\@";'><?= $row->cuenta ?></td>
                <td <?= ($p) ? 'width="15%"' : ''; ?>><?= $row->cuenta_nombre ?></td>
                <td <?= ($p) ? 'width="13%"' : ''; ?>><?= $row->ttb_nombre ?></td>
                <td <?= ($p) ? 'width="18%"' : ''; ?>><?= $row->operacion ?></td>
                <td <?= ($p) ? 'width="11%"' : ''; ?> style="text-align: right;"><?= $simbolo ?> <?= number_format($row->monto, 2) ?></td>
            </tr>
        <?php
        } ?>
    </tbody>
    <tfoot>
        <tr>
            <th colspan="7" style="text-align: right;"><b>Total</b></th>
            <th style="text-align: right; font-family: arial;"><b><?php echo $simbolo .  number_format($total, 2); ?></b></th>
        </tr>
    </tfoot>
</table>