<?php

$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

/**
 * @author alexis
 * @copyright 2014
 */

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="9">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de control de egresos
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php if ($tipo_reporte == 'pdf') : ?>
    <style type="text/css">
        td {
            font-family: courier;
            font-size: 9px;
        }
    </style>
<?php endif; ?>

<?php if ($tipo_reporte == 'pdf' || $tipo_reporte == 'excel') : ?>
    <table border="0" width="100%">
        <tr>
            <td><b>Fecha Inicio: </b><?php echo $fecha_inicio; ?></td>
            <td><b>Fecha Fin: </b><?php echo $fecha_fin; ?></td>
        </tr>
    </table>
<?php endif; ?>

<table border="1px" id="tblListado" class="dynamicTable responsive display table table-bordered" aria-describedby="table_2_info">
    <thead nobr='true'>
        <tr>
            <th width="4%"><b>No.</b></th>
            <th width="14%"><b>BANCO</b></th>
            <th width="12%"><b>No. CTA</b></th>
            <th width="10%"><b>CHEQUE</b></th>
            <th width="21%"><b>A LA ORDEN DE</b></th>
            <th width="9%"><b>FECHA EMISION</b></th>
            <th width="10%"><b>TIPO TRANSACCION</b></th>
            <th width="10%"><b>CONCEPTO</b></th>
            <th width="10%"><b>VALOR PAGADO</b></th>
        </tr>
    </thead>
    <tbody>
        <?php
        $num_row = 0;
        $total   = 0;
        $total1  = 0;
        $total2  = 0;
        foreach ($transacciones as $row) {
            $tipo = $row->tra_id_ttb;
            $m = $row->monto;
            if ($tipo == 6 || $tipo == 2) {
                $total1 += -$row->monto;
                $num_row++;
            }
            if (($tipo == 3 || $tipo == 7) && $m < 0) {
                $total2 += -$row->monto;
                $num_row++;
            }
            if ($m < 0) {
                $monto = abs($row->monto);
            } else {
                $monto = $m;
            }
            $total = $total1 + $total2;
            if (trim($row->alaorden) != "") {
                $beneficiario = $row->alaorden;
            } else {
                $this->db->join('tra_transaccion', 'tra_id_cub = cub_id');
                $destinos = $this->gsatelite->get_tabla('cub_cuenta_bancaria', array('tra_fecha' => $row->fecha, 'tra_id_cub !=' => $row->tra_id_cub));
                if (count($destinos) > 0) {
                    $beneficiario = "Traslado de Fondos hacia Cuenta: " . $destinos[0]['cub_nombre'] . " (" . $destinos[0]['cub_numero'] . ")";
                } else {
                    $beneficiario = "No definido";
                }
            }



            if ($tipo == 6 || $tipo == 2) {
        ?>
                <tr nobr='true'>
                    <td width="4%" style="text-align: left;"><?php echo $num_row; ?></td>
                    <td width="14%"><?php echo $row->ban_nombre; ?></td>
                    <td width="12%" style='mso-number-format:"\@";'><?php echo $row->cuenta; ?></td>
                    <td width="10%"><?php echo preg_replace('/\x{FEFF}/u', '', $row->numero); ?></td>
                    <td width="21%"><?php echo $beneficiario ?></td>
                    <td width="9%"><?php echo formatear_fecha("d-m-Y", $row->fecha); ?></td>
                    <td width="10%"><?php echo $row->concepto; ?></td>
                    <td width="10%"><?php echo $row->concepto_2; ?></td>
                    <td width="10%" style="text-align: right;"><?= $simbolo ?> <?php echo number_format($monto, 2); ?></td>
                </tr>
            <?php
            } else if (($tipo == 3 || $tipo == 7)  && $m < 0) {
            ?>
                <tr nobr='true'>
                    <td width="4%" style="text-align: left;"><?php echo $num_row; ?></td>
                    <td width="14%"><?php echo $row->ban_nombre; ?></td>
                    <td width="12%" style='mso-number-format:"\@";'><?php echo $row->cuenta; ?></td>
                    <td width="10%"><?php echo preg_replace('/\x{FEFF}/u', '', $row->numero); ?></td>
                    <td width="21%"><?php echo $beneficiario ?></td>
                    <td width="9%"><?php echo formatear_fecha("d-m-Y", $row->fecha); ?></td>
                    <td width="10%"><?php echo $row->concepto; ?></td>
                    <td width="10%"><?php echo $row->concepto_2; ?></td>
                    <td width="10%" style="text-align: right;"><?= $simbolo ?> <?php echo number_format($monto, 2); ?></td>
                    <!-- <td width="10%"></td>
                    <td width="10%"></td>                                                                               -->
                </tr>
        <?php
            }
        } ?>
        <?php if (count($transacciones) > 0) : ?>

        <?php else : ?>
            <?php if ($tipo_reporte) : ?>
                <tr>
                    <td align="center" colspan="9" style="width: 100%;">No se encontraron registros</td>
                </tr>
            <?php endif; ?>
        <?php endif; ?>
    </tbody>
    <?php if (count($transacciones) > 0) : ?>
        <tfoot>
            <tr>
                <td colspan="8" style="text-align: right;"><b>Total</b></td>
                <td width="10%" style="text-align: right;"><?= $simbolo ?><?php echo number_format($total, 2); ?></td>
                <!-- <td width="10%"></td>
                <td width="10%">&nbsp;</td>                                     -->
            </tr>
        </tfoot>
    <?php endif ?>
    <!-- <tfoot>
        <tr>            
            <td style="width: 100%; text-align: center;">No se encontraron resultados</td>                                               
        </tr>
    </tfoot> -->

    <!-- <tfoot>
        <tr>            
            <td style="width: 30.7mm;"></td>
            <td style="width: 30.7mm;"></td>
            <td style="width: 30.8mm;"></td>
            <td style="width: 30.7mm;"></td>
            <td style="width: 30.7mm;"></td>
            <td style="width: 31mm;"></td>                        
            <td style="align: right; width: 30.8mm; font-family: courier; font-size: 9px;"><?php echo sprintf("$ %'.8s", number_format($total, 2)); ?></td>
            <td style="width: 30.7mm;"></td>
            <td style="width: 30.7mm;">&nbsp;</td>                        
            
        </tr>
    </tfoot> -->
</table>

<?php if ($tipo_reporte == 'pdf') : ?>

    <table>
        <tr>
            <td>
                <br />
                <br />
                <!-- TESORERO MUNICIPAL -->
            </td>
            <td>
                <?php  ?>
            </td>
        </tr>
    </table>
<?php endif; ?>