<script>
    jQuery(document).ready(function($) {
        $('#contribuyente').buscar2({
            'placeholder': 'Buscar contribuyente',
            'hidden': 'contribuyente_hidden',
            'width': '100%',
            'title': 'Resultados de la búsqueda de contribuyentes',
            'type': 'contribuyentes',
            'style': 'mint',
            'ajax': 'cuentas(this)',
            'label': 'Contribuyente*',
            'icon': 'L'
        });
    });
</script>
<div class="content">
    <form method="POST">
        <div class="content_left">
            <p>
                <input type="text" id="contribuyente">
            </p>
            <p>
                <?= form_dropdown('cnt_id', array(''), set_value('cnt_id', 0)) ?>
                <small>Cuenta Corriente*</small>
            </p>
            <p>
                <input type="submit" class="button tropical small" value="Mostrar Recibos" />
            </p>
        </div>
        <div class="content_right">
            <h4>Recibos Generados.</h4>
            <table class="static_table">
                <thead>
                    <tr>
                        <th>Recibo</th>
                        <th>Fecha</th>
                        <th>Periodo</th>
                        <th>Monto</th>
                    </tr>
                </thead>
                <tbody id="_recibos">
                    <tr>
                        <td colspan="4" class="center">No hay registros.</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </form>
    <div class="clear"></div>
    <div class="content">

    </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        gSateliteBlue.jsSelect();
        $('form').validate({
            ignore: null,
            ignore: 'input[type="hidden"]',
            rules: {
                criterio: {
                    required: true
                },
                cnt_id: {
                    required: true,
                    min: 1
                }
            },
            errorPlacement: function(error, element) {
                error.prependTo(element.parent());
            },
            submitHandler: function(form) {
                console.log($(form).serialize());
                $.ajax({
                    url: satelite.base_url('utm/caja/get_recibos'),
                    type: 'POST',
                    dataType: 'JSON',
                    data: $(form).serialize()
                }).done(function(json) {
                    console.log(json);
                    if (json.response == true) {
                        $('tbody#_recibos').html(json.html);
                    } else {

                    }
                });
            }
        });
    });

    function cuentas(contribuyente) {
        var con_id = contribuyente.id;
        $.ajax({
            url: satelite.base_url('uatm/cuentas/get_cuentas'),
            type: 'POST',
            data: {
                con_id: con_id
            }
        }).done(function(html) {
            console.log(html);
            $('select[name="cnt_id"]').html(html).select2('destroy').select2();
        }).fail(function() {
            alert('Error');
        });
    }
</script>
<script src="<?php echo base_url('scripts/jquery.buscar2.js'); ?>"></script>
<script src="<?php echo base_url('js/sistema/buscar2.js'); ?>"></script>