<div class="container-fluid" style="min-height: 700px;">
    <h3><i class="icon-cog"></i> Configuración de Formularios</h3>
    <hr>

    <!-- FILTROS -->
    <form id="filtros" class="form-inline mb-3">
        <label>Módulo:</label>
        <select id="modulo" class="span3 nostyle">
            <option value="">Seleccione módulo</option>
            <?php foreach ($modulos as $mod): ?>
                <option value="<?= $mod ?>"><?= $mod ?></option>
            <?php endforeach; ?>
        </select>

        <label>Formulario:</label>
        <select id="formulario" class="span4 nostyle" disabled>
            <option value="">Seleccione módulo primero</option>
        </select>

        <button type="submit" class="btn btn-primary" id="btnFiltrar" disabled>
            <i class="icon-search"></i> Filtrar
        </button>
    </form>

    <!-- TABLA -->
    <div id="tabla-container">
        <table class="table table-bordered table-striped table-hover">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Campo</th><th>Tipo</th>
                    <th>Mostrar</th><th>Oblig.</th><th>Edit.</th><th>Defecto</th>
                </tr>
            </thead>
            <tbody id="tablaBody">
                <tr><td colspan="10" class="text-center text-muted">Seleccione filtros y presione <b>Filtrar</b>.</td></tr>
            </tbody>
        </table>
    </div>
</div>

<script>
$(function(){

    $('#modulo').on('change', async function(){
        const modulo = $(this).val();
        const formSel = $('#formulario');
        const btn = $('#btnFiltrar');

        if(!modulo){
            formSel.prop('disabled', true).html('<option value="">Seleccione módulo primero</option>');
            btn.prop('disabled', true);
            return;
        }

        try{
            wait.start('Cargando formularios...');
            const res = await fetch('<?= base_url("sistema/configuraciones/get_formularios_by_modulo") ?>', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'modulo=' + encodeURIComponent(modulo)
            });
            const json = await res.json();
            wait.close();

            if(json.status !== 'ok') throw new Error(json.message);

            formSel.empty().append('<option value="">Todos</option>');
            json.data.forEach(f => formSel.append(`<option value="${f}">${f}</option>`));
            formSel.prop('disabled', false);
            btn.prop('disabled', false);

        }catch(err){
            wait.close();
            console.error(err);
            formSel.html('<option value="">Error al cargar</option>');
        }
    });

    $('#filtros').on('submit', async function(e){
        e.preventDefault();
        const modulo = $('#modulo').val();
        const formulario = $('#formulario').val();
        const tabla = $('#tablaBody');

        if(!modulo){
            alert('Seleccione un módulo');
            return;
        }

        try{
            wait.start('Cargando configuración...');
            const res = await fetch('<?= base_url("sistema/configuraciones/get_configuracion_formularios") ?>', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'modulo=' + encodeURIComponent(modulo) + '&formulario=' + encodeURIComponent(formulario)
            });
            const json = await res.json();
            wait.close();

            tabla.empty();

            if(!json.data || !json.data.length){
                tabla.html('<tr><td colspan="10" class="text-center text-warning">Sin resultados para los filtros seleccionados.</td></tr>');
                return;
            }

            let grupo = '';
            var i = 0;
            json.data.forEach(row=>{
                i++;
                if(row.tab !== grupo){
                    grupo = row.tab;
                    tabla.append(`<tr><td style='color:white;background:#0069B1;text-align:center;font-size:12px;' colspan="10"><strong><i class="icon16 icomoon-icon-grid-view white"></i> ${row.tab.toUpperCase()}</strong></td></tr>`);
                }

                tabla.append(`
                    <tr>
                        <td>${i}</td>
                        <td>${row.campo}</td>
                        <td><span class="badge badge-info">${row.tipo}</span></td>
                        <td class="text-center"><input type="checkbox" class="toggle" data-id="${row.id}" data-field="cfp_mostrar" ${row.mostrar ? 'checked' : ''}></td>
                        <td class="text-center"><input type="checkbox" class="toggle" data-id="${row.id}" data-field="cfp_obligatorio" ${row.obligatorio ? 'checked' : ''}></td>
                        <td class="text-center"><input type="checkbox" class="toggle" data-id="${row.id}" data-field="cfp_editable" ${row.editable ? 'checked' : ''}></td>
                        <td><input type="text" class="input-mini valor_defecto" data-id="${row.id}" value="${row.defecto || ''}"></td>
                    </tr>
                `);
            });

            reactivarEventos();

        }catch(err){
            wait.close();
            console.error(err);
            tabla.html('<tr><td colspan="10" class="text-center text-error">Error al cargar los datos</td></tr>');
        }
    });

    function reactivarEventos(){
        $('.toggle').off('change').on('change', function(){
            const id = $(this).data('id');
            const field = $(this).data('field');
            const value = $(this).is(':checked') ? 1 : 0;
            actualizarCampo(id, field, value);
        });

        $('.valor_defecto').off('blur').on('blur', function(){
            const id = $(this).data('id');
            const value = $(this).val();
            actualizarCampo(id, 'cfp_defecto', value);
        });
    }

    function actualizarCampo(id, campo, valor){
        $.post('<?= base_url("sistema/configuraciones/update_campo") ?>', {id, campo, valor})
        .done(()=>console.log('Actualizado', id, campo, valor))
        .fail(()=>alert('Error al actualizar'));
    }

});
</script>
