<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4><span>Configuración</span></h4>
                <a href="#" class="minimize" style="display: none;">Minimize</a>
            </div>
            <div class="content">
                <div class="row-fluid" style="overflow: auto; height: 60%;">
                    <table border="0" width="100%" cellpadding="2" class="table">
                        <?php if (count($parametros) > 0): ?>
                            <?php foreach ($parametros as $key => $value): ?>
                                <?php
                                $i = $value['prm_id'];
                                switch (trim($value['prm_tipo'])) {
                                    case 'dropdown':
                                        $params   = json_decode($value['prm_data'], true);
                                        $selected = ($value['prm_valor'] != '') ? $value['prm_valor'] : $value['prm_default'];
                                        if (isset($params['array_datos'])) {
                                            $select = "";
                                            $opts = explode(',', $params['array_datos']);
                                            if (count($opts) > 0) {
                                                foreach ($opts as $k => $val) {
                                                    $v = explode('=>', $val);
                                                    $sltd = ($v[0] == $selected) ? 'selected' : '';
                                                    $select .= '<option value="' . $v[0] . '" ' . $sltd . ' >' . $v[1] . '</option>';
                                                }
                                            }
                                        } else {
                                            $prefijo = explode('_',$params['tabla']);
                                            $select  = $this->gsatelite->get_dropdown($params['tabla'], $params['display'], null, trim($params['where']), $selected, '', $prefijo[0].'_id', true);
                                        }                                        
                                        $options  = '<select id="campo_' . $i . '" class="campo nostyle" style="width:100%" data-row ="'. $i .'"><option></option>';
                                        $options .= str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
                                        $options .= '</select>';
                                        break;
                                    case 'boolean':
                                        $options = '<select id="campo_' . $i . '" class="campo nostyle" style="width:100%" id="campo_' . $i . '" data-row ="'. $i .'" >';
                                        $options .= '<option value="1" '.(($value['prm_valor'] == 1) ? 'selected' : '') . ' >Sí</option>';
                                        $options .= '<option value="0" '.(($value['prm_valor'] == 0) ? 'selected' : '') . ' >No</option>';
                                        $options .= '</select>';
                                        break;
                                    case 'json':
                                        $opciones_campos = array_change_key_case(json_decode($value['prm_valor'], true), CASE_UPPER);
                                        if (count($opciones_campos > 0)) {
                                            $j = 0;
                                            $options = '<table id="campo_' . $i . '" data-json="1" border="0">';
                                            foreach ($opciones_campos as $ky => $val) {
                                                $es_id = is_numeric(strpos($ky, 'ID_'));
                                                if ($es_id) {
                                                    $options .= '<tr style="display: none;"><td width="50%">';
                                                    $options .= '<input type="hidden" value="' . $ky . '" class="json_key" id="key_' . $j . '">';
                                                    $options .= '</td><td width="50%">';
                                                    $options .= '<input type="hidden" value="' . $val . '" class="json_val" id="val_' . $j . '">';
                                                    $options .= '</td></tr>';
                                                } else {
                                                    $options .= '<tr><td width="50%">';
                                                    $options .= '<label>' . str_replace(array("_", "ANIO"), array(" ", "AÑO"), $ky) . '</label><input type="hidden" value="' . $ky . '" class="json_key" id="key_' . $j . '">';
                                                    $options .= '</td><td width="50%">';
                                                    $options .= '<input type="text" value="' . $val . '" class="json_val" id="val_' . $j . '" data-row ="'. $i .'">';
                                                    $options .= '</td></tr>';
                                                }
                                                $j++;
                                            }
                                            $options .= '</table>';
                                        }                                        
                                        break;
                                    case 'text':
                                        $options = '<textarea rows="2" style="width: 100%;" class="campo" id="campo_' . $i . '" data-row ="'. $i .'" maxlength="990">' . $value['prm_valor'] . '</textarea>';
                                        break;
                                    case 'int':
                                        $params = json_decode($value['prm_data'], true);
                                        $minimo = (isset($params['minimo'])) ? 'min="' . $params['minimo'] . '"' : '';
                                        $maximo = (isset($params['maximo'])) ? 'max="' . $params['maximo'] . '"' : '';
                                        $options = '<input type="number" value="' . $value['prm_valor'] . '" class="campo soloNumeros" id="campo_' . $i . '" style="width: 100%;" data-row ="'. $i .'" ' . $minimo . ' ' . $maximo . ' >';
                                        break;
                                    default:
                                        $options = '<input type="text" value="' . $value['prm_valor'] . '" class="campo" id="campo_' . $i . '" style="width: 100%;" data-row ="'. $i .'" maxlength="990">';
                                        break;
                                }  
                                ?>
                                <tr>
                                    <td width="45%" ><?php echo $value["prm_nombre"]; ?></td>
                                    <td width="40%">
                                        <?php echo $options; ?>
                                    </td>
                                    <td width="15%" style="text-align: center;">
                                        <button id="guardar_<?= $i ?>" class="btn btn-info guardar" data-row="<?= $i ?>" disabled>Guardar</button>
                                    </td>
                                </tr>
                            <?php endforeach ?>
                        <?php else: ?>
                            <tr>
                                <td style="text-align: center;font-weight: bold;">No hay Parametros Configurados para esta Empresa</td>
                            </tr>
                        <?php endif ?>
                    </table>
                </div>
                <div class="row-fluid" style="text-align: center;">
                    <div class="form-actions span12" style="text-align: center;">
                        <button type="button" class="btn btn-danger" id="cancelar" onclick="parent.$.fancybox.close()">
                            <span class="icon16 icomoon-icon-cancel-2 white"> Cerrar</span>
                        </button>
                    </div>
                </div>
            </div><!-- END CONTENT -->
        </div><!-- end box -->
    </div>
</div>
 

<script type="text/javascript">
    $(document).ready(function(){
        $("select").select2({placeholder : 'Seleccione'});

        $("select.campo").change(function(){
            activar_boton($(this).data('row'));
        });

        $("input.campo, textarea.campo").keyup(function(){
            activar_boton($(this).data('row'));
        });

        $("input.json_val").keyup(function(){
            var valor = $(this).val();
            var fila = $(this).data('row');
            if (valor.trim() != "") {
                $("#guardar_" + fila).removeAttr('disabled');
            } else {
                $("#guardar_" + fila).attr("disabled", "disabled");   
            }
        });
        
        $(".guardar").click(function(){
            var id = $(this).data('row');
            var valor = $('#campo_' + id).val();
            var esjson = $('#campo_' + id).data('json');
            var url = urlj + 'sistema/catalogo/actualizar_parametros';
            if (typeof esjson != 'undefined') {
                var new_valor = new Array();
                var mijson = {};
                var llaves = [];
                var valores = [];
                $("#campo_" + id +" .json_key").each(function(index, value) {
                    llaves.push(value.value)
                });
                $("#campo_" + id +" .json_val").each(function(index, value) {
                    valores.push(value.value);
                });
                $.each(llaves, function(index, value ) {
                    mijson[value] = valores[index];
                });
                new_valor.push(mijson);
                valor = JSON.stringify(new_valor);
                url = urlj + 'sistema/catalogo/actualizar_parametros/1';
            }
            if ($("#campo_" + id).is('[type="number"]')) {
                let vmin = parseInt($("#campo_" + id).attr('min'));
                let vmax = parseInt($("#campo_" + id).attr('max'));
                if (parseInt(valor) <  vmin || parseInt(valor) >  vmax) {
                    crear_alerta("error", "Rango numérico", "Verifica que el valor esté dentro del rango");
                    return false;
                }
                if (parseInt(valor) == 0) {
                    valor = "";
                }
            }
            $.ajax({
                type: 'POST',
                url: url, 
                dataType: 'text',
                data: {
                    id: id,
                    valor: valor
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    if (data > 0) {
                        crear_alerta('success','Éxito', 'Se guardó la información correctamente');
                        $("#guardar_" + id).attr("disabled", "disabled");   
                    } else {
                        crear_alerta('error','Error', 'No fue posible guardar la información');
                    }
                }
            });
            wait.close();
        });       

    });//END document.ready

    function activar_boton(fila) {
        var valor = $("#campo_" + fila).val();
        if (valor.trim() != "") {
            $("#guardar_" + fila).removeAttr('disabled');
        } else {
            $("#guardar_" + fila).attr("disabled", "disabled");   
        }
    }

</script>
<style type="text/css">
    input[type=number]::-webkit-inner-spin-button,
    input[type=number]::-webkit-outer-spin-button {
        -webkit-appearance: none;
        margin: 0;
    }
    input[type=number] { -moz-appearance:textfield; }
</style>
