<?php
// Impresion de EXCEL
if(isset($excel)){
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}?>

<?php if(isset($excel) || isset($pdf)) { ?>
<style type="text/css">
    .tabla{
        font-weight: normal !important;
        border:1px solid black;
    }
    .tabla th{
        border:1px solid black;
        vertical-align: middle;
        text-align: center;
    }
    .tabla td{
        border:1px solid black;
        vertical-align: middle;
        text-align: center;
    }
</style>
<?php 
    $tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO"); 
    $titulo = 'Reporte de horarios de supervisored / coordinadores'; 
    echo $header;
?>

<?php } ?>
<?php if(isset($pdf)) {
    echo '<br><br>';
} ?>
<?php if($tipo_reporte != '') { ?>
<table border="0">
        <tr><td colspan="7"></td></tr>
        <tr>
            <td style="text-align: left;" colspan="3"><b>Fecha Desde:</b><?php echo formatear_fecha('d-m-Y', $fechaDesde); ?>&nbsp;</td>
            <td style="text-align: left;" colspan="3">&nbsp;&nbsp;<b>Fecha Hasta:</b>&nbsp;<?php echo formatear_fecha('d-m-Y', $fechaHasta); ?></td>
        </tr>
        <tr>
            <td colspan="7"></td>  
        </tr>
    </table>
    <br>
<?php } ?>
<?php if(isset($pdf) && $pdf==1 || isset($excel) && $excel==1) { ?>
<table class="tabla" cellpadding="2" align="center">
    <thead>
        <tr nobr="true">
            <th style="font-weight:bold;font-size:9px">N°</th>
            <th style="font-weight:bold;font-size:9px">Supervisor / Coordinador</th>
            <th style="font-weight:bold;font-size:9px">Fecha Inicio</th>
            <th style="font-weight:bold;font-size:9px">Fecha Fin</th>
            <th style="font-weight:bold;font-size:9px">Dia</th>
            <th style="font-weight:bold;font-size:9px">Horario</th>
            <th style="font-weight:bold;font-size:9px">Estado</th>

        </tr>
    </thead>
    <tbody id="consulta_table">
<?php } ?>
<?php if (count($horarios)>0) { ?>
        <?php foreach ($horarios as $key => $value) { ?>
            <tr nobr="true">  

                <td><?php echo ($key+1); ?></td>
                <td><?php echo $value['emp_nombre'].' '.$value['emp_apellido']; ?></td>
                <td><?php echo formatear_fecha('d-m-Y', $value['hrs_fecha_inicio']); ?></td>
                <td><?php echo formatear_fecha('d-m-Y', $value['hrs_fecha_fin']); ?></td>
                <td>
                    <?php foreach ($dias as $k => $v) {
                        if ($value['dhr_id_dia']==$v['dia_id']) echo $v['dia_nombre'];
                    } ?>
                </td>
                <td>
                    <?php foreach ($hrg as $k => $v) {
                        if ($value['dhr_id_hrg']==$v['hrg_id']) echo date("h:i A", strtotime($v['hrg_inicio'])).' - '.date("h:i A", strtotime($v['hrg_fin']));
                    } ?>
                </td>
                <td><?php echo ($value['dhr_estado']==1)?'Activo':'Inactivo'; ?></td>
                
            </tr>
    <?php    } ?>
<?php } ?>

<?php if(isset($pdf) && $pdf==1) { ?>
    </tbody> 
</table>
<?php } ?>