<?php 
$p = ($tipo == 'pdf') ? true : false;
if ($tipo == 'exc') {
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=modalidad_estudio.xls");
    ?>
    <meta charset="utf-8" />
    <div class="head">
        <table border="0">
            <tr>
                <td align="center" colspan="6">
                    <h4><?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?></h4>
                    Reporte de Modalidad de Estudio por Alumno
                </td>
            </tr>
        </table>
    </div>
    <br>
    <?php
}
?>
<table class="responsive dynamicTable table table-bordered" id="datagried1" border="1" cellpadding="1" >
    <thead>
        <tr style="font-weight: bold;">
            <th <?= ($p)?'width="4%"':''; ?>>#</th>
            <th <?= ($p)?'width="17%"':''; ?>>Área Académica</th>
            <th <?= ($p)?'width="17%"':''; ?>>Grupo Académico</th>
            <th <?= ($p)?'width="17%"':''; ?>>Frecuencia</th>
            <th <?= ($p)?'width="28%"':''; ?>>Estudiante</th>
            <th <?= ($p)?'width="17%"':''; ?>>Modalidad</th>
        </tr>
    </thead>
    <tbody>
        <?php if (count($registros) > 0) {
            $i = 1;
            foreach ($registros as $k => $val) {
                ?>
                <tr nobr="true">
                    <td <?= ($p)?'width="4%"':''; ?> ><?= $i ?></td>
                    <td <?= ($p)?'width="17%"':''; ?>><?= $val['ard_nombre']; ?></td>
                    <td <?= ($p)?'width="17%"':''; ?>><?= $val['gra_nombre']; ?></td>
                    <td <?= ($p)?'width="17%"':''; ?>><?= $val['frh_nombre']; ?></td>
                    <td <?= ($p)?'width="28%"':''; ?>><?= $val['alm_nombre'].' '.$val['alm_apellido']; ?></td>
                    <td <?= ($p)?'width="17%"':''; ?>><?= (intval($val['lxp_modalidad']) > 0) ? 'Modalidad Virtual' :'Modalidad Presencial'; ; ?></td>
                </tr>
                <?php
                $i++;
            }
        } else {
            if ($tipo != "") {
                ?>
                <tr><td colspan="6" style="text-align:center;">No se encontraron registros</td></tr>
                <?php
            }
        } ?>
    </tbody>             
 </table>
 <?php if ($tipo == "") { ?>
    <script type="text/javascript">
        $(document).ready(function(){
            $('#datagried1').dataTable({"iDisplayLength": 5, "sPaginationType": "full_numbers"});
            var contador=1;
            while(contador<4){
                $("#datagried" +contador+ "_length select").html("<option value='5'>5</option>");
                $("#datagried" +contador+ "_length select").append("<option value='10'>10</option>");
                $("#datagried" +contador+ "_length select").append("<option value='15'>15</option>");
                $("#datagried" +contador+ "_length select").append("<option value='20'  selected='selected' >20</option>");
                contador++;
            }
            setTimeout(function(){
                $('#datagried1_length select').trigger('change');
            },200);
        });
    </script>
<?php } ?>