<?php
// Impresion de EXCEL
if (isset($excel)) {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
} ?>

<?php
$width = '';
$widthNombre = '';
if ($dias_fechas >= 18) {
    $width = 'width="20"';
    $widthNombre = 'width="50"';
} elseif ($dias_fechas < 10 && $dias_fechas > 15) {
    $width = 'width="15"';
}

?>

<?php if (isset($excel)) { ?>
    <?php $tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO"); ?>
    <style type="text/css">
        table {
            margin: 0 auto;
        }

        td {
            text-align: center;
            font-family: arial;
        }

        .impar {
            background-color: #D7E5F7;
        }

        .par {
            background-color: #B9D5F7;
        }

        .fuente_titulo {
            font-family: <?php echo $tipo_fuente; ?>;
        }
    </style>
    <table align="center" cellpadding="0">
        <tr>
            <td align="left" width="20%">
                <?php
                $colspan = "";
                $colspan2 = 0;
                ?>

                <img src="<?php echo base_url(); ?>media/imagenes/sistema/<?php echo $this->gsatelite->get_parametro('SYS_LOGOTIPO') ?>.png" width="208px" height="88">

            </td>
            <td width="65%" colspan="6">
                <br>

                <span style="font-size: 14px; font-weight: bold;" class="fuente_titulo">
                    <?php
                    echo $this->gsatelite->get_parametro('SYS_EMPRESA');
                    ?>
                </span>

                <h4>
                    Reporte de asistencia
                </h4>
            </td>

        </tr>

        <tr>
            <td colspan="6" style="text-align: right; size: 8;font-weight: bold;"><?php echo $this->tank_auth->get_username() ?></td>
        </tr>
        <tr>
            <td colspan="6" style="text-align: right; size: 8;font-weight: bold;border-bottom-style:solid;"><?php echo $this->gsatelite->get_parametro('SYS_DEPARTAMENTO') . ', ' . date('d-m-Y H:i:s a'); ?></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
        </tr>
        <?php //} 
        ?>
    </table>


<?php } ?>

<?php if (isset($excel) || isset($pdf)) { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;

        }

        .tabla th {

            vertical-align: middle;
            text-align: center;
        }

        .tabla td {

            vertical-align: middle;
            text-align: center;
        }
    </style>

    <table border="0" width="105%">
        <tr>
            <td style="width: 8%; text-align: left;"><b>Proyección:</b></td>
            <td style="text-align: left;"><?php echo $proyeccion[0]['pyc_nombre']; ?></td>
            <td style="width: 9%; text-align: left;"><b>Fecha Inicio:</b></td>
            <td style="text-align: left;"><?php echo formatear_fecha('d-m-Y', $proyeccion[0]['pyc_fecha_inicio']); ?></td>
            <td style="width: 15%; text-align: left;"><b>Fecha Fin:</b></td>
            <td> <?php echo formatear_fecha('d-m-Y', $proyeccion[0]['pyc_fecha_fin']); ?></td>
        </tr>
        <br>

        <tr>
            <td style="width: 8%; text-align: left;"><b>Área:</b></td>
            <td style="text-align: left;"><?php echo $area[0]['ard_nombre']; ?></td>
            <td style="width: 9%; text-align: left;"><b>Nivel/curso/materia:</b></td>
            <td style="text-align: left;"><?php echo (isset($pensum[0]['mod_nombre'])) ? $pensum[0]['mod_nombre'] : ''; ?></td>
            <td style="width: 15%; text-align: left;"><b>Sección:</b></td>
            <td> <?php echo (isset($seccion[0]['scc_nombre'])) ? $seccion[0]['scc_nombre'] : ''; ?></td>

        </tr>
        <br>

        <tr>
            <td style="width: 8%; text-align: left;"><b>Frecuencia:</b> </td>
            <td style="text-align: left;"><?php echo (isset($frecuencia[0]['frh_nombre'])) ? $frecuencia[0]['frh_nombre'] : ''; ?></td>
            <td style="width: 9%; text-align: left;"><b>Docente:</b></td>
            <td style="text-align: left;"><?php echo $docente[0]['emp_apellido'] . ', ' . $docente[0]['emp_nombre']; ?></td>

            <td style="width: 15%; text-align: left;"><b>Supervisor / Coordinador: </b></td>
            <td style="text-align: left;"><?php echo $supervisor[0]['emp_apellido'] . ' ' . $supervisor[0]['emp_nombre']; ?></td>
        </tr><br>
        <tr>
            <td style="width: 10%;text-align: left;">
                <h4>P = Presente</h4>
            </td>
            <td style="width: 10%;text-align: left;">
                <h4>A = Ausente</h4>
            </td>
        </tr>
        <tr>
            <?php if (isset($pdf)) { ?>
                <td style="width: 10%; text-align: left;"></td>
                <td style="text-align: left;"></td>
            <?php } ?>

            <td style="width: 15%; text-align: left;"></td>
            <td style="text-align: left;"></td>

            <?php if (isset($excel)) { ?>
                <td style="width: 10%; text-align: left;"></td>
                <td style="text-align: left;"></td>
            <?php } ?>

            <td style="text-align: left;">

            </td>
        </tr>
        <tr>
            <td width="90%">
                <hr>
            </td>
        </tr>
        <tr>
            <td width="45%"><b>Fecha Inicio: </b><?php echo formatear_fecha('d-m-Y', $fechaInicio); ?></td>
            <td width="45%"><b>Fecha Fin: </b><?php echo formatear_fecha('d-m-Y', $fechaFin); ?></td>
        </tr>
        <tr>
            <td width="90%">
                <hr>
            </td>
        </tr>

    </table>

<?php } ?>
<?php if (isset($pdf)) {
    echo '<br><br><br>';
} ?>

<!-- *********************************************** -->
<!-- Cabecera que se imprimira en los reportes de PDF y Excel -->
<?php if (isset($pdf) && $pdf == 1 || isset($excel) && $excel == 1) { ?>
    <table class="tabla" cellpadding="1" cellspacing="0.5" align="center" border="1" style="border-style:solid !important;font-size: 8.5px">
        <thead>
            <tr>
                <th style="font-weight:bold;font-size:9px;border-style:solid !important;" width="5%">N°</th>
                <th style="font-weight:bold;font-size:9px;border-style:solid !important;" width="15%">Carnet</th>
                <th style="font-weight:bold;font-size:9px;border-style:solid !important;" <?php if (isset($excel)) {
                                                                                                echo 'colspan="4"';
                                                                                            } ?> width="30%"> Nombre</th>
                <?php
                // Recorrer los dias que seran mostrados y que han asistido
                $fechas = array();

                if (count($alumnos) > 0) {
                    foreach ($alumnos as $key => $value) {
                        $asistencias = explode(',', $value['asistencias']);
                        foreach ($asistencias as $k => $v) {
                            $fecha = explode('&', $v);
                            $fechas[] = formatear_fecha('d', $fecha[0]);
                            $fecha = explode('&', $v);

                            echo '<th width="20" style="font-weight:bold;font-size:8px;border-style:solid !important;">' . formatear_fecha('d', $fecha[0]) . '</th>';
                        }
                        break; // Detener la ejecucion
                    }
                }
                ?>
                <th style="font-weight:bold;font-size:9px;border-style:solid !important;" width="7%">Total A</th>
                <th style="font-weight:bold;font-size:9px;border-style:solid !important;" width="7%">Total P</th>

            </tr>
        </thead>
        <tbody id="tbContenedor">
        <?php } ?>
        <!-- *********************************************** -->

        <!-- *********************************************** -->
        <!-- Esta es la cabecera que se imprimira en la grid -->
        <?php if (!isset($pdf) && !isset($excel)) { ?>
            <table id="tblContenedor" class="dynamicTable responsive display table table-bordered" aria-describedby="table_2_info" border="0">
                <thead>
                    <tr style="background-color: #C0C0C0;">

                        <th>N°</th>
                        <th>Carnet</th>
                        <th>Nombre</th>
                        <?php
                        $fechas = array();

                        // Recorrer los dias que seran mostrados y que han asistido
                        if (count($alumnos) > 0) {
                            foreach ($alumnos as $key => $value) {
                                $asistencias = explode(',', $value['asistencias']);

                                foreach ($asistencias as $k => $v) {
                                    $fecha = explode('&', $v);
                                    $fechas[] = formatear_fecha('d', $fecha[0]);
                                    echo '<th width="20" >' . formatear_fecha('d', $fecha[0]) . '</th>';
                                }
                                break; // Detener la ejecucion
                            }
                        }
                        ?>
                        <th>Total A</th>
                        <th>Total P</th>

                    </tr>
                </thead>
                <tbody id="tbContenedor">
                <?php } ?>
                <!-- *********************************************** -->

                <?php if (count($alumnos) > 0) { ?>
                    <?php $i = 0; ?>
                    <?php
                    $dias = array();
                    foreach ($alumnos as $key => $value) {
                        $dias = explode(',', $value['asistencias']);
                        $totalP = 0;
                        $totalA = 0;
                    ?>
                        <tr nobr="true">

                            <td width="5%"><?php echo ($i + 1); ?></td>
                            <td width="15%"><?php echo $value['alm_codigo']; ?></td>
                            <td width="30%" <?php if (isset($excel)) {
                                                echo 'colspan="4"';
                                            } ?>><?php echo $value['alm_nombre'] . ' ' . $value['alm_apellido']; ?></td>
                            <?php
                            // Mostrar si asistio o no a la clase
                            foreach ($fechas as $fec) { // Fechas en los que se tomó asistencia
                                $fecha2 = explode('&', $v2);
                                $day2 = $fecha2[0];
                                $estado = 0;

                                foreach ($dias as $k => $v2) { // Días en que el alumno asistió. 
                                    $fecha = explode('&', $v2);
                                    $day = formatear_fecha('d', $fecha[0]);

                                    if ($day == $fec && $fecha[1] == 1) { // Mostrar P de presente si asistio
                                        echo '<td width="20">P</td>';
                                        $totalP += 1;
                                        $estado = 1;
                                    } else if ($day == $fec && $fecha[1] != 1) { // Mostrar A de ausente para no asistio
                                        echo '<td width="20">A</td>';
                                        $totalA += 1;
                                        $estado = 1;
                                    }
                                }

                                if ($estado == 0) {
                                    echo '<td></td>';
                                }
                            }


                            $estado = 0;
                            ?>
                            <td width="7%"><?php echo $totalA; ?></td>
                            <td width="7%"><?php echo $totalP; ?></td>

                        </tr>
                        <?php $i++; ?>
                    <?php    } ?>
                <?php } ?>

                </tbody>
            </table>