<?php
// Impresion de EXCEL
if (isset($excel)) {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
} ?>

<?php if (isset($excel) || isset($pdf)) { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            border: 1px solid black;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }
    </style>
    <?php
    $tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");
    $titulo = 'Reporte de alumnos con beneficio';
    if (isset($excel)) {
    ?>
        <table align="center" cellpadding="0">
            <tr style="text-align: center;">
                <?php if (isset($excel)) echo '<td></td>'; ?>
                <td colspan="3">
                    <span style="font-size: 13px;" class="fuente_titulo">
                        <?php echo $this->gsatelite->get_parametro('SYS_EMPRESA'); ?>
                    </span>
                    <br>
                    <span style="font-size: 12px;" class="fuente_titulo">
                        <?php
                        echo strtoupper($titulo);
                        ?>
                    </span><br><br>
                    <span style="font-size: 12px;" class="fuente_titulo">
                        <b>Fecha Desde:</b><?php echo formatear_fecha('d-m-Y', $fechaDesde); ?>&nbsp;&nbsp;<b>Fecha Hasta:</b>&nbsp;<?php echo formatear_fecha('d-m-Y', $fechaHasta); ?>
                    </span>
                </td>

            </tr>
        </table>
<?php
    } else {
        echo $header;
    }
}
?>
<?php if (isset($pdf)) {
    echo '<br><br>';
} ?>
<?php if ($tipo_reporte != '') { ?>
    <table class="">

        <tr>
            <td style="width: 15%; text-align: center;"></td>
            <td style="text-align: left;"></td>
            <td style="width: 12%; text-align: left;"></td>
            <td style="text-align: left;"></td>
        </tr>

    </table>
    <br>
<?php } ?>
<?php if (isset($pdf) && $pdf == 1 || isset($excel) && $excel == 1) { ?>
    <table class="tabla" cellpadding="2" align="center">
        <thead>
            <tr nobr="true">

                <th style="font-weight:bold;font-size:9px">N°</th>
                <th style="font-weight:bold;font-size:9px">Código</th>
                <th style="font-weight:bold;font-size:9px">Nombre</th>
                <th style="font-weight:bold;font-size:9px">Tipo de Beneficio</th>
                <th style="font-weight:bold;font-size:9px">Porcentaje</th>
                <th style="font-weight:bold;font-size:9px">Descuento</th>
                <th style="font-weight:bold;font-size:9px">Factura</th>
                <th style="font-weight:bold;font-size:9px">Fecha</th>

            </tr>
        </thead>
        <tbody id="consulta_table">
        <?php } ?>
        <?php if (count($alumnos) > 0) { ?>
            <?php $i = 0; ?>
            <?php foreach ($alumnos as $key => $value) { ?>
                <?php $factura = explode(',', $value['factura']); ?>
                <?php if (count($factura) > 1) { ?>
                    <tr nobr="true">

                        <td><?php echo ($i + 1); ?></td>
                        <td><?php echo $value['alm_codigo']; ?></td>
                        <td><?php echo $value['alm_nombre'] . ' ' . $value['alm_apellido']; ?></td>
                        <td><?php echo $value['tbf_nombre']; ?></td>
                        <td><?php echo number_format($value['apb_porcentaje']); ?></td>
                        <td>
                            <?php if (count($factura) > 1) {
                                echo $factura[0];
                            } ?>
                        </td>
                        <td>
                            <?php if (count($factura) > 1) {
                                echo $factura[1];
                            } ?>
                        </td>
                        <td>
                            <?php if (count($factura) > 1) {
                                echo formatear_fecha('d-m-Y', $factura[2]);
                            } ?>
                        </td>

                    </tr>
                    <?php $i++; ?>
                <?php } ?>
            <?php    } ?>
        <?php } ?>

        <?php if (isset($pdf) && $pdf == 1) { ?>
        </tbody>
    </table>
<?php } ?>