<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="4">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Materia Prima por Orden de Producción
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php if (count($orden) > 0) : ?>
    <?php
    $cliente  = $orden[0]['cli_codigo'] . ' - ';
    $cliente .= ($orden[0]['cli_personeria'] == 1) ? $orden[0]['cli_nombre'] . ' ' . $orden[0]['cli_apellido'] : $orden[0]['cli_apellido'];
    $articulo = $orden[0]['axo_id_art'];
    $titulo = true;
    $salto = ($tipo_reporte == 'pdf') ? '<br><hr><br>' : '<br>';
    $borde = ($tipo_reporte == 'pdf') ? 'style="font-weight: bold; border: solid 1px black;"' : 'style="font-weight: bold;"';
    ?>
    <table border="0" width="100%" cellpadding="3" class="table responsive table-bordered display">
        <thead>
            <tr>
                <th width="15%">Código Orden: </th>
                <th width="35%"><?php echo $orden[0]['ord_codigo']; ?></th>
                <th width="15%">Fecha Orden: </th>
                <th width="35%"><?php echo formatear_fecha('d-m-Y', $orden[0]['ord_fecha']); ?></th>
            </tr>
            <tr>
                <th>Cliente</th>
                <th colspan="3"><?php echo $cliente; ?></th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td colspan="4"><?php foreach ($orden as $key => $value) : ?><?php if ($value['axo_id_art'] == $articulo) : ?><?php if ($titulo) : ?><table cellpadding="2" width="100%" class="table responsive table-bordered display" border="0">
                        <thead>
                            <tr>
                                <th style="font-weight: bold;" width="15%">Producto: </th>
                                <th width="45%"><?php echo $value['producto']; ?></th>
                                <th style="font-weight: bold; text-align: right;" width="20%">Cantidad a Producir: </th>
                                <th width="20%"><?php echo number_format($value['axo_cantidad'], 2); ?></th>
                            </tr>
                            <tr style="text-align: center;">
                                <th <?php echo $borde; ?> width="15%">Código</th>
                                <th <?php echo $borde; ?> width="40%">Nombre</th>
                                <th <?php echo $borde; ?> width="25%">Total a Solicitar</th>
                                <th <?php echo $borde; ?> width="20%">Medida</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $titulo = false; ?>
                        <?php endif ?>
                        <tr>
                            <td><?php echo $value['art_codigo']; ?></td>
                            <td><?php echo $value['art_nombre']; ?></td>
                            <td style="text-align: right;">
                                <?php echo ($value['axm_cantidad'] != "") ? number_format($value['axm_cantidad'], 2) : number_format(($value['mpa_cantidad'] * $value['axo_cantidad']), 2); ?>
                            </td>
                            <td><?php echo $value['mep_nombre']; ?></td>
                        </tr>
                    <?php else : ?>
                        </tbody>
                    </table><?php echo $salto; ?><?php $titulo = true;
                                                                                $articulo = $value['axo_id_art']; ?><?php if ($titulo) : ?><table cellpadding="2" width="100%" class="table responsive table-bordered display" border="0">
                        <thead>
                            <tr>
                                <th style="font-weight: bold;" width="15%">Producto: </th>
                                <th width="45%"><?php echo $value['producto']; ?></th>
                                <th style="font-weight: bold; text-align: right;" width="20%">Cantidad a Producir: </th>
                                <th width="20%"><?php echo number_format($value['axo_cantidad'], 2); ?></th>
                            </tr>
                            <tr>
                                <th <?php echo $borde; ?> width="15%">Código</th>
                                <th <?php echo $borde; ?> width="40%">Nombre</th>
                                <th <?php echo $borde; ?> width="25%">Total a Solicitar</th>
                                <th <?php echo $borde; ?> width="20%">Medida</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $titulo = false; ?>
                        <?php endif ?>
                        <tr>
                            <td><?php echo $value['art_codigo']; ?></td>
                            <td><?php echo $value['art_nombre']; ?></td>
                            <td style="text-align: right;">
                                <?php echo ($value['axm_cantidad'] != "") ? number_format($value['axm_cantidad'], 2) : number_format(($value['mpa_cantidad'] * $value['axo_cantidad']), 2); ?>
                            </td>
                            <td><?php echo $value['mep_nombre']; ?></td>
                        </tr>
                    <?php endif ?>
                <?php endforeach ?>
                        </tbody>
                    </table>
                </td>
            </tr>
        </tbody>
    </table>
<?php else : ?>
    <table border="0" width="100%" cellpadding="3">
        <tr>
            <th style="text-align: center;font-weight: bold;">No Se Encontró Información</th>
        </tr>
    </table>
<?php endif ?>