<?php
if ($tipo_reporte == 'excel') {
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header("content-disposition: attachment; filename=" . $filename . ".xls");
	header("Pragma: no-cache");
	header("Expires: 0");
?>
	<meta charset="utf-8" />
	<div class="head">
		<table>
			<tr>
				<td align="center" colspan="11">
					<h4>
						<?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?>
						<br>
						Reporte de Productos Fabricados
					</h4>
				</td>
			</tr>
		</table>
	</div>
	<br>
<?php
	$p = false;
} else {
	$p = true;
?>
	<style>
		th {
			font-size: 7px;
			font-weight: bold;
			justify-content: center;
			align-items: center;
			text-align: center;
			background-color: #49afcd;
			color: white;
		}

		table {
			border-collapse: collapse;
		}
	</style>
<?php
} ?>
<table cellpadding="1" border="1" style="table-layout:fixed;">
	<thead>
		<tr>
			<th <?= ($p) ? 'width="17%"' : '' ?>>Producto</th>
			<th <?= ($p) ? 'width="8%"' : '' ?>>Cod.Orden</th>
			<th <?= ($p) ? 'width="17%"' : '' ?>>Cliente </th>
			<th <?= ($p) ? 'width="7%"' : '' ?>>Cantidad fabricada</th>
			<th <?= ($p) ? 'width="7%"' : '' ?>>Materia Prima</th>
			<th <?= ($p) ? 'width="7%"' : '' ?>>Mano Obra</th>
			<th <?= ($p) ? 'width="8%"' : '' ?>>Costo Primo</th>
			<th <?= ($p) ? 'width="7%"' : '' ?>>Gastos indirectos</th>
			<th <?= ($p) ? 'width="7%"' : '' ?>>Prod. semi-terminado</th>
			<th <?= ($p) ? 'width="8%"' : '' ?>>Costo producción</th>
			<th <?= ($p) ? 'width="7%"' : '' ?>>Costo unitario</th>
		</tr>
	</thead>
	<tbody>
		<?php
		if (count($productos) > 0) {
			$total_can_fabricadas = $total_mat_prima = $total_mano_obra = $total_costo_primo = $total_gasto_in = $total_semi = $total_costo_prod = $total_unitario = 0;
			for ($i = 0; $i < count($productos); $i++) {
				$articuloxorden = $this->gsatelite->get_tabla('axo_articuloxorden', array('axo_id_art' => $productos[$i]['art_id'], 'axo_id_ord' => $productos[$i]['ord_id']));
				if (count($articuloxorden) > 0) {
					for ($k = 0; $k < count($articuloxorden); $k++) {
						$data_materia_prima = $this->proyecto_model->get_materia_prima_presupuesto(array('axm_id_axo' => $articuloxorden[$k]['axo_id']));
						$data_mano_obra = $this->proyecto_model->get_mano_obra_presupuesto(array('mxo_id_axo' => $articuloxorden[$k]['axo_id']));
						$data_gastos_indirectos = $this->proyecto_model->get_gastos_indirectos_presupuesto(array('exr_id_axo' => $articuloxorden[$k]['axo_id']));

						$orden = $this->gsatelite->get_tabla('ord_orden', array('ord_id' => $articuloxorden[$k]['axo_id_ord']));
						$cliente = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $orden[0]['ord_id_cli']));
						$nombre_cliente = $cliente[0]['cli_nombre'] . ' ' . $cliente[0]['cli_apellido'];
						$producto = trim($productos[$i]['art_codigo']) . "-" . trim($productos[$i]['art_nombre']);

						$materia_prima = $mano_obra = $chk_est = 0;
						$materia_prima_semi = $gasto_indirectos = 0;

						foreach ($data_materia_prima as $key => $value) {
							if ($value['art_produccion'] > 0) {
								//Esto es para producto semi terminado
								$materia_prima_semi += ($value['axm_cantidad'] * $value['axm_precio']);
							} else {
								$materia_prima += ($value['axm_cantidad'] * $value['axm_precio']);
							}
							if ($value['axm_estimacion_porcentaje'] > 0) {
								$chk_est += ($value['axm_cantidad'] * $value['axm_precio']);
							}
						}

						foreach ($data_mano_obra as $key2 => $value2) {
							$mano_obra += ($value2['mxo_cantidad'] * $value2['mxo_precio']);
							if ($value2['mxo_estimacion_porcentaje'] > 0) {
								$chk_est += ($value2['mxo_cantidad'] * $value2['mxo_precio']);
							}
						}
						$costo_primo = $materia_prima + $mano_obra;

						if (count($data_gastos_indirectos) > 0) {
							foreach ($data_gastos_indirectos as $key3 => $data) {
								if ($data['esm_tipo_calculo'] == 0) {
									// porcentaje
									if (isset($data['exr_id']) && $data['exr_id'] != null) {
										$cantidad_gasto = $data['exr_cantidad'];
										$gasto_indirectos += $data['exr_monto_calculo'];
									} else {
										$cantidad_gasto = $data['esr_cantidad'];
										$gasto_indirectos += $data['esr_monto_calculo'];
									}
								} else {
									// monto
									if (isset($data['exr_id']) && $data['exr_id'] != null) {
										$cantidad_gasto = $data['exr_cantidad'];
										$precio_gasto = $data['exr_precio'];
									} else {
										$cantidad_gasto = ($data['esr_cantidad'] * $articuloxorden[$k]['axo_cantidad']);
										$precio_gasto = $data['esr_precio'];
									}
									$gasto_indirectos += ($cantidad_gasto * $precio_gasto);
								}
							}
						}
						$costo_prod = $costo_primo + $gasto_indirectos + $materia_prima_semi;
						$subtotalGasto = $gasto_indirectos;

						$costo_unitario = $costo_prod / $articuloxorden[$k]['axo_cantidad'];
						$total_can_fabricadas += $articuloxorden[$k]['axo_cantidad'];

						$total_mat_prima += $materia_prima;
						$total_mano_obra += $mano_obra;
						$total_costo_primo += $costo_primo;
						$total_gasto_in += $subtotalGasto;

						$semi_terminado = $materia_prima_semi;
						$total_semi += $semi_terminado;

						$total_costo_prod += $costo_prod;
						$total_unitario += $costo_unitario;
		?>
						<tr nobr="true">
							<td <?= ($p) ? 'width="17%"' : '' ?>><?php echo $producto; ?></td>
							<td <?= ($p) ? 'width="8%"' : '' ?>><?php echo $orden[0]['ord_codigo']; ?></td>
							<td <?= ($p) ? 'width="17%"' : '' ?>><?php echo $nombre_cliente; ?></td>
							<td <?= ($p) ? 'width="7%"' : '' ?> style="text-align: right;"><?php echo number_format($articuloxorden[$k]['axo_cantidad']); ?></td>
							<td <?= ($p) ? 'width="7%"' : '' ?> style="text-align: right;"><?php echo number_format($materia_prima, 2); ?></td>
							<td <?= ($p) ? 'width="7%"' : '' ?> style="text-align: right;"><?php echo number_format($mano_obra, 2); ?></td>
							<td <?= ($p) ? 'width="8%"' : '' ?> style="text-align: right;"><?php echo number_format($costo_primo, 2); ?></td>
							<td <?= ($p) ? 'width="7%"' : '' ?> style="text-align: right;"><?php echo number_format($subtotalGasto, 2); ?></td>
							<td <?= ($p) ? 'width="7%"' : '' ?> style="text-align: right;"><?php echo number_format($semi_terminado, 2); ?></td>
							<td <?= ($p) ? 'width="8%"' : '' ?> style="text-align: right;"><?php echo number_format($costo_prod, 2); ?></td>
							<td <?= ($p) ? 'width="7%"' : '' ?> style="text-align: right;"><?php echo number_format($costo_unitario, 2); ?></td>
						</tr>
			<?php
					}
				}
			}
		} else {
			?>
			<tr>
				<td colspan="11" style="text-align: center;">No hay datos que mostrar</td>
			</tr>
		<?php
		}
		?>
	</tbody>
	<?php if (count($productos) > 0) { ?>
		<tfoot>
			<tr>
				<td colspan="3" style="font-weight: bold;">Totales</td>
				<td style="text-align: right; font-weight: bold;"><?php echo $total_can_fabricadas; ?></td>
				<td style="text-align: right; font-weight: bold;"><?php echo $simbolo . number_format($total_mat_prima, 2); ?></td>
				<td style="text-align: right; font-weight: bold;"><?php echo $simbolo . number_format($total_mano_obra, 2); ?></td>
				<td style="text-align: right; font-weight: bold;"><?php echo $simbolo . number_format($total_costo_primo, 2); ?></td>
				<td style="text-align: right; font-weight: bold;"><?php echo $simbolo . number_format($total_gasto_in, 2); ?></td>
				<td style="text-align: right; font-weight: bold;"><?php echo $simbolo . number_format($total_semi, 2); ?></td>
				<td style="text-align: right; font-weight: bold;"><?php echo $simbolo . number_format($total_costo_prod, 2); ?></td>
				<td style="text-align: right; font-weight: bold;"><?php // echo $simbolo.number_format($total_unitario, 2); 
																	?></td>
			</tr>
		</tfoot>
	<?php } ?>
</table>