<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<?php if ($tipo_reporte != '' && $tipo_reporte == 'pdf') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 0.5px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 0.5px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte != '' && $tipo_reporte == 'excel') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
            border: 2px solid black;
        }

        .tabla th {
            border: 2px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 2px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Uso de Materia Prima
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<table class="" cellpadding="2">
    <tbody>
        <tr>
            <td colspan="4"></td>
        </tr>
        <tr>
            <td style="text-align: left;width: 8%;"><b>Orden:</b></td>
            <td style="text-align: left;"><?php echo $orden[0]['ord_codigo']; ?></td>
            <td style="text-align: left;width: 12%;"><b>Tipo Orden:</b></td>
            <td style="text-align: left;"><?php echo $orden[0]['tio_nombre']; ?></td>
        </tr>
        <?php

        $nombre_cliente =  $orden[0]['cli_codigo'] . ' - ';
        $nombre_cliente .= ($orden[0]['cli_personeria'] == 1) ? $orden[0]['cli_nombre'] . ' ' . $orden[0]['cli_apellido'] : $orden[0]['cli_apellido'];
        ?>
        <tr>
            <td style="text-align: left;width: 8%;"><b>Cliente:</b></td>
            <td style="text-align: left;"><?php echo $nombre_cliente; ?></td>
            <td style="text-align: left;width: 12%;"><b>Fecha Orden:</b></td>
            <td style="text-align: left;"><?php echo formatear_fecha('d-m-Y', $orden[0]['ord_fecha']); ?></td>
        </tr>
    </tbody>
</table>
<div></div>
<?php $clases = ($tipo_reporte != 'excel') ? 'responsive table table-bordered contenedor' : ''; ?>
<table class="tabla <?php echo $clases; ?>" cellpadding="2">
    <tbody class="tabla">
        <tr>
            <td colspan="7" style="text-align: center;"><b>Materia Prima</b></td>
        </tr>
        <?php
        $registros = 1;
        foreach ($detalle_orden as $key => $row) :
        ?>
            <tr>
                <td colspan="7" style="text-align: left;background-color: #ced2d4;">
                    Producto: <b><?php echo $row['art_codigo'] . ' - ' . $row['art_nombre']; ?></b>
                </td>
            </tr>
            <tr>
                <td colspan="7" style="text-align: left;background-color: #ced2d4;">
                    Cantidad: <b><?php echo $row['axo_cantidad']; ?></b>
                </td>
            </tr>
            <?php
            $detalle_id = $row['axo_id'];
            $receta = ($row['axo_id_rea'] > 0) ? $row['axo_id_rea'] : $this->gsatelite->get_campo('rea_receta_articulo', 'rea_id', array('rea_estado' => 1, 'rea_id_art' => $row['axo_id_art'], 'rea_defecto' => 1));

            $this->db->join("axm_articulo_matxarticulo_ord", "axm_id_art_materia = mpa_id_art_materia and axm_id_axo = '$detalle_id'", "left");
            $materia_prima = $this->proyecto_model->get_materia_prima_producto(array('mpa_id_art' => $row['axo_id_art'], 'mpa_id_rea' => $receta));
            $idsMateriaPrima = array();
            //Materia Prima
            if (count($materia_prima) > 0) :
                $totalMp = 0;
                $idsMateriaPrima = array_column($materia_prima, 'mpa_id_art_materia');
            ?>
                <tr>
                    <th>Código Mp.</th>
                    <th>Materia Prima</th>
                    <th>Unida de Medida</th>
                    <th>Cantidad Estandar</th>
                    <th>Cantidad Solicitada</th>
                    <!-- <th>Cantidad Solicitada</th> -->
                    <th>Diferencia</th>
                </tr>
                <?php
                foreach ($materia_prima as $mpa) :
                    $subtotal = $mpa['axm_cantidad'] * $mpa['axm_cantidad'];
                    $totalMp += $subtotal;

                    $cantidad_estandar = $mpa['mpa_cantidad'];
                    $cantidad_total = $cantidad_estandar * $row['axo_cantidad'];
                    $cantidad_solicitada = $mpa['axm_cantidad']; // * $row['axo_cantidad'];
                    $diferencia = ($cantidad_solicitada > 0) ? $cantidad_total - $cantidad_solicitada : 0;
                ?>
                    <tr>
                        <td><?php echo $mpa['art_codigo']; ?></td>
                        <td><?php echo $mpa['art_nombre']; ?></td>
                        <td><?php echo $mpa['mep_nombre']; ?></td>
                        <td><?php echo number_format($cantidad_total, 2); ?></td>
                        <td><?php echo number_format($cantidad_solicitada, 2); ?></td>
                        <!-- <td><?php /*echo number_format($cantidad_solicitada, 2);*/ ?></td> -->
                        <td>
                            <?php
                            $dif = number_format(number_format($cantidad_solicitada, 2) - number_format($cantidad_total, 2), 2);
                            $dif = ($dif < 0) ? "(" . $dif . ")" : $dif;
                            echo $dif;
                            // echo number_format($diferencia, 2); 
                            ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else : ?>
                <tr>
                    <td colspan="7" style="text-align: center;"> No se encontraron registros. </td>
                </tr>
            <?php endif; ?>
            <tr>
                <td colspan="7" style="text-align: center;background-color: #b1d4e6;"><b>Fuera de Estándar</b></td>
            </tr>
            <?php
            //End Productos

            if (count($idsMateriaPrima) > 0) {
                $this->db->where_not_in('axm_id_art_materia', $idsMateriaPrima);
            }
            $materia_prima_pres = $this->proyecto_model->get_materia_prima_presupuesto(array('axm_id_axo' => $row['axo_id']));

            if (count($materia_prima_pres) > 0) :
                $totalMp = 0;
            ?>
                <tr>
                    <th colspan="2">Código Mp.</th>
                    <th>Materia Prima</th>
                    <th>Unida de Medida</th>
                    <th>Cantidad</th>
                    <th>Precio U.</th>
                    <th>Sub - total</th>
                </tr>
                <?php
                foreach ($materia_prima_pres as $axm) :
                    $subtotal = $axm['axm_cantidad'] * $axm['axm_precio'];
                ?>
                    <tr>
                        <td colspan="2"><?php echo $axm['art_codigo']; ?></td>
                        <td><?php echo $axm['art_nombre']; ?></td>
                        <td><?php echo $axm['mep_nombre']; ?></td>
                        <td><?php echo number_format($axm['axm_cantidad'], 2); ?></td>
                        <td><?= $simbolo ?><?php echo number_format($axm['axm_precio'], 2); ?></td>
                        <td><?= $simbolo ?><?php echo number_format($subtotal, 2); ?></td>
                    </tr>
                <?php
                endforeach;
            endif;
            if ($registros < count($detalle_orden)) :
                ?>
                <tr>
                    <td colspan="7"></td>
                </tr>
        <?php
            endif;
            $registros++;
        endforeach;
        ?>
    </tbody>
</table>