<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<?php if ($tipo_reporte != '' && $tipo_reporte == 'pdf') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 0.5px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 0.5px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte != '' && $tipo_reporte == 'excel') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
            border: 2px solid black;
        }

        .tabla th {
            border: 2px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
            font-size: 12px !important;
        }

        .tabla td {
            border: 2px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Requisición de Materiales
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<table cellpadding="1" width="100%" border="0">
    <tbody>
        <tr>
            <td style="text-align: left;" width="18%"><b>Requisición:</b></td>
            <td style="text-align: left;" width="30%"><?php echo $requisicion[0]['rxi_numero']; ?></td>
            <td style="text-align: left;" width="18%"><b>Orden:</b></td>
            <td style="text-align: left;" width="34%"><?php echo $requisicion[0]['ord_codigo']; ?></td>
        </tr>
        <tr>
            <td style="text-align: left;"><b>Concepto:</b></td>
            <td style="text-align: left;"><?php echo $requisicion[0]['ord_concepto']; ?></td>
            <td style="text-align: left;"><b>Depto. Solicitante:</b></td>
            <td style="text-align: left;"><?php echo $requisicion[0]['are_nombre']; ?></td>
        </tr>
        <tr>
            <td style="text-align: left;"><b>Nombre Solicitante:</b></td>
            <td style="text-align: left;"><?php echo $requisicion[0]['emp_nombre'] . ' ' . $requisicion[0]['emp_apellido']; ?></td>
            <td style="text-align: left;"><b>Producto:</b></td>
            <td style="text-align: left;"><?php echo $producto[0]['art_codigo']  . ' - ' . $producto[0]['art_nombre']; ?></td>
        </tr>
        <tr>
            <td style="text-align: left;"><b>Fecha:</b></td>
            <td style="text-align: left;"><?php echo formatear_fecha('d-m-Y', $requisicion[0]['rxi_fecha']); ?></td>
            <td colspan="2"></td>
        </tr>
    </tbody>
</table>
<div></div>
<?php $clases = ($tipo_reporte != 'excel') ? 'responsive table table-bordered contenedor' : ''; ?>
<table class="tabla <?php echo $clases; ?>" cellpadding="2">
    <thead>
        <tr>
            <th width="65%">Descripción</th>
            <th width="35%">Cantidad</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $registros = 1;
        $totalMateriales = 0;
        foreach ($detalle_requisicion as $key => $row) :
            $totalMateriales += $row['dri_cantidad'];
        ?>
            <tr>
                <td style="text-align: left;" width="65%"><?php echo $row['art_codigo'] . ' - ' . $row['art_nombre']; ?></td>
                <td style="text-align: right;" width="35%"><?php echo number_format($row['dri_cantidad'], 2); ?></td>
            </tr>
        <?php
            //End Productos
            $registros++;
        endforeach;
        ?>
        <tr>
            <td style="text-align: right;"><b>Total</b></td>
            <td style="text-align: right;"><?php echo number_format($totalMateriales, 2); ?></td>
        </tr>
    </tbody>
</table>
<div></div>
<br /><br /><br /><br />
<table class="" cellpadding="2" border="0">
    <tbody>
        <tr>
            <td style="width: 15%;" height="30px"></td>
            <td style="text-align: left;width: 25%;border-top: 1px solid black;"><b>Solicitado por:</b></td>
            <td style="width: 25%;"></td>
            <td style="text-align: left;width: 25%;border-top: 1px solid black;"><b>Entregado por:</b></td>
        </tr>
        <tr>
            <td style="width: 15%;"></td>
            <td style="text-align: left;width: 25%;"></td>
            <td style="width: 25%;"></td>
            <td style="text-align: left;width: 25%;"></td>
        </tr>
        <tr>
            <td style="width: 15%;"></td>
            <td style="text-align: left;width: 25%;border-top: 1px solid black;"><b>Autorizado por:</b></td>
            <td style="width: 25%;"></td>
            <td style="text-align: left;width: 25%;border-top: 1px solid black;"><b>Recibido por:</b></td>
        </tr>
    </tbody>
</table>