<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        <?php echo $titulo; ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<style type="text/css">
    .totales {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }

    .titulo {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }
</style>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla td {
            vertical-align: middle;
            text-align: center;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
            font-size: 10px;
        }
    </style>
<?php } ?>
<?php $encabezado = ($tipo_reporte == 'pdf') ? 'style="font-size: 8px !important;"' : ""; ?>
<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
    <?php } else { ?>
        <table class="responsive display table table-bordered dataTable" id="tbl_table" name="tbl_table" border="0" style="margin-left: 4px; width: 99%; font-size:12px;">
        <?php } ?>
        <thead>
            <tr>
                <th <?= $encabezado ?>>Orden</th>
                <!-- <th width="22%" <?= $encabezado ?>>PROYECTO</th> -->
                <th <?= $encabezado ?>>Fecha de Creación</th>
                <th <?= $encabezado ?>>Fecha de Programación</th>
                <!-- <th width="10%" <?= $encabezado ?>>FECHA DE PRESENTACIÓN</th> -->
                <th <?= $encabezado ?>>Producto</th>
                <th <?= $encabezado ?>>Cantidad</th>
                <!-- <th <?= $encabezado ?>>Costeo</th> -->
            </tr>
        </thead>
        <tbody id="tbl_contenedor">
            <?php if (count($consulta) > 0) : ?>
                <?php foreach ($consulta as $key => $detalle) : ?>
                    <?php $proyecto = ($detalle["pcl_codigo"] != "" && $detalle["pcl_nombre"] != "") ? $detalle["pcl_codigo"] . ' - ' . $detalle["pcl_nombre"] : ""; ?>
                    <tr>
                        <td><?php echo $detalle["ord_codigo"]; ?></td>
                        <!-- <td><?php //echo $proyecto; 
                                    ?></td> -->
                        <td><?php echo formatear_fecha('d-m-Y', $detalle["ord_fecha"]); ?></td>
                        <td><?php echo formatear_fecha('d-m-Y', $detalle["dpp_fecha_inicio"]); ?></td>
                        <!-- <td><?php //echo ($detalle["cot_fecha_pres"] != "" ) ? date('d-m-Y', strtotime($detalle["cot_fecha_pres"])) : ""; 
                                    ?></td> -->
                        <td><?php echo $detalle["art_codigo"] . ' - ' . $detalle["art_nombre"]; ?></td>
                        <td style="text-align: right;"><?php echo number_format($detalle['axo_cantidad'], 2); ?></td>
                        <!-- <td style="text-align: right;"><?php //echo ($detalle['axo_total'] > 0) ? '$' . number_format($detalle['axo_total'], 2) : "--"; 
                                                            ?></td> -->
                    </tr>
                <?php endforeach ?>
            <?php else : ?>
                <tr>
                    <td colspan="5" style="text-align: center;"><b>No se encontraron resultados</b></td>
                </tr>
            <?php endif ?>
        </tbody>
        </table>