<style type="text/css">
    td {
        font-family: arial;
        font-size: 10px;
    }
</style>
<?php
$pdf = ($tipo_reporte == 'pdf') ? true : false;
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

if ($tipo_reporte == 'excel') {
?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="5">
                    <h4>
                        <?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?>
                        <br />
                        <?php echo 'Reporte de ' . $titulo; ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<table border="0" width="100%">
    <tr>
        <th><b>Fecha Inicio: </b><?php echo $fecha_inicio; ?></th>
        <th><b>Fecha Fin: </b><?php echo $fecha_fin; ?></th>
    </tr>
</table>
<table border="1" width="100%">
    <thead>
        <tr>
            <th <?= ($pdf) ? 'width="5%"' : ""; ?>><b>Código</b></th>
            <th <?= ($pdf) ? 'width="24%"' : ""; ?>><b>Cliente</b></th>
            <th <?= ($pdf) ? 'width="10%"' : ""; ?>><b>Cod. de Orden</b></th>
            <th <?= ($pdf) ? 'width="10%"' : ""; ?>><b>Fecha Orden</b></th>
            <th <?= ($pdf) ? 'width="14%"' : ""; ?>><b>Tipo Orden</b></th>
            <th <?= ($pdf) ? 'width="23%"' : ""; ?>><b>Concepto</b></th>
            <th <?= ($pdf) ? 'width="14%"' : ""; ?>><b>Fecha Programación</b></th>
        </tr>
    </thead>
    <tbody>
        <?php
        if ($ordenes) :
            $numero_fila = 1;
            foreach ($ordenes as $orden) :
                $nombre_cliente = ($orden['cli_personeria'] == 1) ? $orden['cli_nombre'] . ' ' . $orden['cli_apellido'] : $orden['cli_apellido'];
        ?>
                <tr nobr="true">
                    <td <?= ($pdf) ? 'width="5%"' : ""; ?>><?= $numero_fila++ ?></td>
                    <td <?= ($pdf) ? 'width="24%"' : ""; ?>><?= $nombre_cliente ?></td>
                    <td <?= ($pdf) ? 'width="10%"' : ""; ?>><?= $orden['ord_codigo'] ?></td>
                    <td <?= ($pdf) ? 'width="10%"' : ""; ?>><?= formatear_fecha('d-m-Y', $orden['ord_fecha']) ?></td>
                    <td <?= ($pdf) ? 'width="14%"' : ""; ?>><?= $orden['tio_nombre'] ?></td>
                    <td <?= ($pdf) ? 'width="23%"' : ""; ?>><?= $orden['ord_concepto'] ?></td>
                    <td <?= ($pdf) ? 'width="14%"' : ""; ?>><?= formatear_fecha("d-m-Y", $orden["dpp_fecha_inicio"]) ?></td>
                </tr>
            <?php
            endforeach;
        else :
            ?>
            <tr>
                <td colspan="4" align="center">No se encontraron registros</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>