<?php
$decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
if ($tipo_reporte == 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
}
if ($tipo_reporte != '') {
    if ($tipo_reporte == 'excel') {
?>
        <meta charset="utf-8" />
        <div class="head">
            <table>
                <tr>
                    <td align="center" colspan="6">
                        <h4>
                            <?php
                            echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                            ?> <br />
                            Reporte de Producción General
                        </h4>
                    </td>
                </tr>
            </table>
        </div>
    <?php
    }
    ?>
    <br>
    <table border="1" width="100%">
        <thead>
            <tr>
                <th width="12%"><b>Código</b></th>
                <th width="25%"><b>Descripción</b></th>
                <th width="15%"><b>Unidades</b></th>
                <th width="12%"><b>U. M.</b></th>
                <th width="12%"><b>Orden Prod.</b></th>
                <th width="12%"><b>Fecha Orden</b></th>
                <th width="12%"><b>Costeo</b></th>
            </tr>
        </thead>
        </thead>
        <tbody>
            <?php
        }

        if (count($ordenes) > 0) {
            foreach ($ordenes as $key => $value) {
            ?>
                <tr nobr="true">
                    <td width="12%"><?php echo $value['art_codigo']; ?></td>
                    <td width="25%"><?php echo $value['art_nombre']; ?></td>
                    <td width="15%" style="text-align: right;"><?php echo number_format($value['axo_cantidad'], $decimales); ?></td>
                    <td width="12%"><?php echo $value['mep_nombre']; ?></td>
                    <td width="12%"><?php echo $value['ord_codigo']; ?></td>
                    <td width="12%"><?php echo formatear_fecha('d-m-Y', $value['ord_fecha']); ?></td>
                    <td width="12%" style="text-align: <?php echo ($value['axo_total'] > 0) ? 'right' : 'center'; ?>;">
                        <?php echo ($value['axo_total'] > 0) ? '$' . number_format($value['axo_total'], 2) : '--'; ?>
                    </td>
                </tr>
            <?php
            }
        }

        if ($tipo_reporte != '') {
            ?>
        </tbody>
    </table>
<?php
        }
?>