<?php
$dec = $this->gsatelite->get_parametro('NUMERO_DECIMALES');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}


if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Ordenes de Producción Finalizadas
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php
}

if ($tipo_reporte != "") {
?>
    <table class="table" cellpadding="1" width="100%" border="1">
        <thead>
            <tr style="font-weight: bold;">
                <th width="12%">Código Orden</th>
                <th width="19%">Cliente</th>
                <th width="20%">Producto</th>
                <th width="16%">Cantidad Planeada</th>
                <th width="17%">Cantidad Producida</th>
                <th width="16%">Fecha Finalización</th>
            </tr>
        </thead>
        <tbody>
        <?php
    }
        ?>

        <?php
        if (count($datos) > 0) {
            $total_planeado = 0;
            $total_producido = 0;
            foreach ($datos as $key => $value) {
                $total_planeado += number_format($value['lop_cantidad'], $dec, '.', '');
                $total_producido += number_format($value['axo_cantidad'], $dec, '.', '');
        ?>
                <tr>
                    <td width="12%"><?php echo $value['ord_codigo']; ?></td>
                    <td width="19%"><?php echo $value['cliente']; ?></td>
                    <td width="20%"><?php echo $value['art_codigo'] . ' - ' . $value['art_nombre']; ?></td>
                    <td width="16%" style="text-align: right;"><?php echo number_format($value['lop_cantidad'], $dec); ?></td>
                    <td width="17%" style="text-align: right;"><?php echo number_format($value['axo_cantidad'], $dec); ?></td>
                    <td width="16%"><?php echo formatear_fecha('d-m-Y', $value['ord_fecha_ejecucion']); ?></td>
                </tr>
            <?php
            }
        } else {
            ?>
            <tr>
                <td colspan="6" style="font-weight: bold; text-align: center;">No se encontraron resultados</td>
            </tr>
        <?php
        }
        ?>

        <?php
        if ($tipo_reporte != "") {
        ?>
        </tbody>
        <tfoot>
            <tr>
                <td style="text-align: right; font-weight: bold;" colspan="3">Total</td>
                <td style="text-align: right;"><?php echo number_format($total_planeado, $dec); ?></td>
                <td style="text-align: right;"><?php echo number_format($total_producido, $dec); ?></td>
                <td></td>
            </tr>
        </tfoot>
    </table>
<?php
        }
?>