<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<?php if ($tipo_reporte != '' && $tipo_reporte == 'pdf') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 0.5px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 0.5px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte != '' && $tipo_reporte == 'excel') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
            border: 2px solid black;
        }

        .tabla th {
            border: 2px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 2px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Orden de Trabajo
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<table class="" cellpadding="2">
    <tbody>
        <tr>
            <td colspan="4"></td>
        </tr>
        <tr>
            <td style="text-align: left;width: 8%;"><b>Orden:</b></td>
            <td style="text-align: left;"><?php echo $orden[0]['ord_codigo']; ?></td>
            <td style="text-align: left;width: 12%;"><b>Fecha Orden:</b></td>
            <td style="text-align: left;"><?php echo formatear_fecha('d-m-Y', $orden[0]['ord_fecha']); ?></td>
        </tr>
        <tr>
            <td style="text-align: left;width: 8%;"><b>Fecha de Entrega:</b></td>
            <td style="text-align: left;"><?php echo formatear_fecha('d-m-Y', $orden[0]['ord_fecha_entr']); ?></td>
        </tr>
    </tbody>
</table>
<div></div>
<?php $clases = ($tipo_reporte != 'excel') ? 'responsive table table-bordered contenedor' : ''; ?>
<table class="tabla <?php echo $clases; ?>" cellpadding="2">
    <tbody class="tabla">
        <tr>
            <td colspan="6" style="text-align: center;"></td>
        </tr>
        <tr>
            <th colspan="2">Cod. Producto</th>
            <th colspan="2">Nombre Producto</th>
            <th colspan="2">Cantidad</th>
        </tr>
        <?php
        $registros = 1;
        foreach ($detalle_orden as $key => $row) :
        ?>
            <tr>
                <td colspan="2"><?php echo $row['art_codigo']; ?></td>
                <td colspan="2"><?php echo $row['art_nombre']; ?></td>
                <td colspan="2"><?php echo $row['axo_cantidad']; ?></td>
            </tr>
        <?php
            $registros++;
        endforeach;
        ?>
        <tr>
            <td colspan="6" style="text-align: center;"><b>Presupuestos</b></td>
        </tr>
        <?php
        $registros = 1;
        $totalMateriaPrima = 0;
        $totalManoObra = 0;
        $totalGastosIndirectos = 0;
        foreach ($detalle_orden as $key => $row) :
        ?>
            <tr>
                <td colspan="6" style="text-align: left;background-color: #ced2d4;">
                    Producto: <b><?php echo $row['art_codigo'] . ' - ' . $row['art_nombre']; ?></b>
                </td>
            </tr>
            <tr>
                <td colspan="6" style="text-align: left;background-color: #ced2d4;">
                    Cantidad: <b><?php echo $row['axo_cantidad']; ?></b>
                </td>
            </tr>
            <?php
            $materia_prima = $this->proyecto_model->get_materia_prima_presupuesto(array('axm_id_axo' => $row['axo_id']));
            $mano_obra = $this->proyecto_model->get_mano_obra_presupuesto(array('mxo_id_axo' => $row['axo_id']));
            $gastos_indirectos = $this->proyecto_model->get_gastos_indirectos_presupuesto(array('exr_id_axo' => $row['axo_id']));



            //Materia Prima
            if (count($materia_prima) > 0) :
                $totalMp = 0;
            ?>
                <tr>
                    <th>Código Mp.</th>
                    <th>Materia Prima</th>
                    <th>Unida de Medida</th>
                    <th>Cantidad</th>
                    <th>Precio U.</th>
                    <th>Sub - total</th>
                </tr>
                <?php
                foreach ($materia_prima as $axm) :
                    $subtotal = $axm['axm_cantidad'] * $axm['axm_precio'];
                    $totalMp += $subtotal;
                ?>
                    <tr>
                        <td><?php echo $axm['art_codigo']; ?></td>
                        <td><?php echo $axm['art_nombre']; ?></td>
                        <td><?php echo $axm['mep_nombre']; ?></td>
                        <td><?php echo number_format($axm['axm_cantidad'], 2); ?></td>
                        <td><?= $simbolo ?><?php echo number_format($axm['axm_precio'], 2); ?></td>
                        <td><?= $simbolo ?><?php echo number_format($subtotal, 2); ?></td>
                    </tr>
                <?php endforeach; ?>
                <tr>
                    <td colspan="4"></td>
                    <td><b>Total</b></td>
                    <td><?= $simbolo ?><?php
                                        $totalMateriaPrima += $totalMp;
                                        echo number_format($totalMp, 2);
                                        ?></td>
                </tr>
            <?php endif; ?>
            <tr>
                <td colspan="6" style=""></td>
            </tr>

            <?php
            //Mano de Obra
            if (count($mano_obra) > 0) :
                $totalMob = 0;
            ?>
                <tr>
                    <th>Código Mo.</th>
                    <th>Mano de Obra</th>
                    <th>Responsable</th>
                    <th>Cantidad</th>
                    <th>Precio U.</th>
                    <th>Sub - total</th>
                </tr>
                <?php
                foreach ($mano_obra as $mxo) :
                    $subtotal = $mxo['mxo_cantidad'] * $mxo['mxo_precio'];
                    $totalMob += $subtotal;
                ?>
                    <tr>
                        <td><?php echo $mxo['mob_codigo']; ?></td>
                        <td><?php echo $mxo['mob_nombre']; ?></td>
                        <td><?php echo $mxo['emp_nombre'] . ' ' . $mxo['emp_apellido']; ?></td>
                        <td><?php echo number_format($mxo['mxo_cantidad'], 2); ?></td>
                        <td><?= $simbolo ?><?php echo number_format($mxo['mxo_precio'], 2); ?></td>
                        <td><?= $simbolo ?><?php echo number_format($subtotal, 2); ?></td>
                    </tr>
                <?php endforeach; ?>
                <tr>
                    <td colspan="4"></td>
                    <td><b>Total</b></td>
                    <td><?= $simbolo ?><?php
                                        $totalManoObra += $totalMob;
                                        echo number_format($totalMob, 2);
                                        ?></td>
                </tr>
            <?php endif; ?>
            <tr>
                <td colspan="6" style=""></td>
            </tr>
            <?php
            //Gastos Indirectos
            if (count($gastos_indirectos) > 0) :
                $totalGasto = 0;
            ?>
                <tr>
                    <th>Código Eg.</th>
                    <th colspan="2">Estimación de gastos</th>
                    <th>Cantidad</th>
                    <th>Precio U.</th>
                    <th>Sub - total</th>
                </tr>
                <?php
                foreach ($gastos_indirectos as $exr) :
                    $subtotal = $exr['exr_cantidad'] * $exr['exr_precio'];
                    $totalGasto += $subtotal;
                ?>
                    <tr>
                        <td><?php echo $exr['esm_codigo']; ?></td>
                        <td colspan="2"><?php echo $exr['esm_nombre']; ?></td>
                        <td><?php echo number_format($exr['exr_cantidad'], 2); ?></td>
                        <td><?= $simbolo ?><?php echo number_format($exr['exr_precio'], 2); ?></td>
                        <td><?= $simbolo ?><?php echo number_format($subtotal, 2); ?></td>
                    </tr>
                <?php endforeach; ?>
                <tr>
                    <td colspan="4"></td>
                    <td><b>Total</b></td>
                    <td><?= $simbolo ?><?php
                                        $totalGastosIndirectos += $totalGasto;
                                        echo number_format($totalGasto, 2);
                                        ?></td>
                </tr>
            <?php endif; ?>
        <?php
            //End Productos
            $registros++;
        endforeach;
        $totalGeneral = $totalMateriaPrima + $totalManoObra + $totalGastosIndirectos;
        ?>
        <tr>
            <td colspan="6" style="text-align: center;"><b>Presupuesto Total</b></td>
        </tr>
        <tr>
            <td colspan="3" style="font-weight: bold;">Materia Prima</td>
            <td colspan="3" style="font-weight: bold;"><?= $simbolo ?><?php echo number_format($totalMateriaPrima, 2); ?></td>
        </tr>
        <tr>
            <td colspan="3" style="font-weight: bold;">Mano de Obra</td>
            <td colspan="3" style="font-weight: bold;"><?= $simbolo ?><?php echo number_format($totalManoObra, 2); ?></td>
        </tr>
        <tr>
            <td colspan="3" style="font-weight: bold;">Estimación de Gastos</td>
            <td colspan="3" style="font-weight: bold;"><?= $simbolo ?><?php echo number_format($totalGastosIndirectos, 2); ?></td>
        </tr>
    </tbody>
</table>