<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<?php if ($tipo_reporte != '' && $tipo_reporte == 'pdf') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 0.5px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 0.5px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte != '' && $tipo_reporte == 'excel') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
            border: 2px solid black;
        }

        .tabla th {
            border: 2px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 2px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Orden de Producción
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<table class="" cellpadding="2">
    <tbody>
        <tr>
            <td colspan="4"></td>
        </tr>
        <tr>
            <td style="text-align: left;width: 8%;"><b>Orden:</b></td>
            <td style="text-align: left;"><?php echo $orden[0]['ord_codigo']; ?></td>
            <td style="text-align: left;width: 12%;"><b>Tipo Orden:</b></td>
            <td style="text-align: left;"><?php echo $orden[0]['tio_nombre']; ?></td>
        </tr>
        <?php
        $nombre_cliente = ($orden[0]['cli_personeria']) ? $orden[0]['cli_nombre'] . ' ' . $orden[0]['cli_apellido'] : $orden[0]['cli_apellido'];
        ?>
        <tr>
            <td style="text-align: left;width: 8%;"><b>Cliente:</b></td>
            <td style="text-align: left;"><?php echo $nombre_cliente; ?></td>
            <td style="text-align: left;width: 12%;"><b>Fecha Orden:</b></td>
            <td style="text-align: left;"><?php echo formatear_fecha('d-m-Y', $orden[0]['ord_fecha']); ?></td>
        </tr>
        <tr>
            <td style="text-align: left;width: 8%;"><b>Fecha Entrega:</b></td>
            <td style="text-align: left;"><?php echo formatear_fecha('d-m-Y', $orden[0]['ord_fecha_entr']); ?></td>
            <td style="text-align: left;"><b>Total:</b></td>
            <td style="text-align: left;"><?= array_sum(array_column($detalle_orden, 'axo_cantidad')) ?></td>
        </tr>
    </tbody>
</table>
<div></div>
<?php $clases = ($tipo_reporte != 'excel') ? 'responsive table table-bordered contenedor' : ''; ?>
<table class="tabla <?php echo $clases; ?>" cellpadding="2">
    <thead>
        <tr>
            <th colspan="2">Cod. Producto</th>
            <th colspan="2">Producto</th>
            <th colspan="2">Descripción</th>
            <th colspan="2">Cantidad</th>
        </tr>
    </thead>
    <tbody class="tabla">
        <?php
        $registros = 1;
        $totalOrden = 0;
        foreach ($detalle_orden as $key => $row) :
            $totalOrden += $row['axo_cantidad'];
        ?>
            <tr>
                <td colspan="2"><?= $row['art_codigo'] ?></td>
                <td colspan="2"><?= $row['art_nombre'] ?></td>
                <td colspan="2"><?= (isset($row['axo_descripcion']) && $row['axo_descripcion'] != "") ? $row['axo_descripcion'] : $row['art_nombre'] ?></td>
                <td colspan="2"><?= number_format($row['axo_cantidad'], 2) ?></td>
            </tr>
        <?php
            $registros++;
        endforeach;
        ?>
        <tr>
            <td colspan="6"><b>Total</b></td>
            <td colspan="2"><?php echo $totalOrden; ?></td>
        </tr>
    </tbody>
</table>

<?php if ($tipo_reporte == 'pdf') :
?>
    <br><br><br><br><br><br>
    <table>
        <tr>
            <td style="width:70px;"></td>
            <td style="width:150px;font-weight: bold;">________________________________</td>
            <td></td>
            <td style="width:150px;font-weight: bold;">________________________________</td>
            <td style="width:70px;"></td>
        </tr>

        <tr>
            <td style="width:70px;"></td>
            <td style="text-align: center;width:150px;font-weight: bold;">Entregado por</td>
            <td></td>
            <td style="text-align: center;width:150px;font-weight: bold;">Recibido por:</td>
            <td style="width:70px;"></td>
        </tr>
        <tr>
            <td style="width:70px;"></td>
            <td style="text-align: center;width:150px;font-weight: bold;"><?php echo $usuario[0]['emp_nombre'] . " " . $usuario[0]['emp_apellido'] ?></td>
            <td></td>
            <td style="text-align: center;width:150px;font-weight: bold;"></td>
            <td style="width:70px;"></td>
        </tr>
    </table>
<?php
endif;
?>