<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Horas Extras
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
$periodo = "";
if ($fecha_inicio != null && $fecha_fin != null) {

    $fecha_inicio = $fecha_inicio;
    $fecha_fin = $fecha_fin;

    $periodo = $fecha_inicio . "/" . $fecha_fin;
}

//Si la variable tipo reporte existe se declara la tabla
$i = 1;
$registros = 1;
$pagina = null;
$noBr = ($tipo_reporte != '' && $tipo_reporte == 'pdf') ? 'nobr="true"' : '';
$totalHoras = 0;

$cliente = $orden[0]['cli_codigo'] . " - ";
$cliente .= ($orden[0]['cli_personeria'] == 1) ? $orden[0]['cli_nombre'] . ' ' . $orden[0]['cli_apellido'] : $orden[0]['cli_apellido'];
foreach ($reporte as $row) :
    if ($tipo_reporte != '') {

        if ($registros == 1) {
?>
            <table class="">
                <tr>
                    <td colspan="2"></td>
                </tr>
                <tr>
                    <td style="text-align: left;width: 8%;"><b>Cliente:</b></td>
                    <td style="text-align: left;width: 25%;"><?php echo $cliente; ?></td>
                    <td style="width: 10%;"><b>Período:</b></td>
                    <td style="text-align: left;"><?php echo $periodo; ?></td>
                </tr>
            </table>
            <div></div>
        <?php } ?>
        <?php if ($i == 1) {
        ?>
            <table class="tabla">
                <thead>
                    <tr>
                        <th>Empleado</th>
                        <th>Fecha</th>
                        <th>Hora Inicio</th>
                        <th>Hora Fin</th>
                        <th>No. Orden</th>
                        <th>Total Horas</th>
                        <th>Precio</th>
                        <th>Monto</th>
                    </tr>
                </thead>
                <tbody>
            <?php
        }
    }
    $empleado           = $row['emp_codigo'] . ' - ' . $row['emp_nombre'] . ' ' . $row['emp_apellido'];
    $factor             = $row['the_factor'];
    $monto_total_horas  = ((($row['emp_salario'] / 240) * $factor) * $row['hxe_num_hora']);
    $precio             = $monto_total_horas / $row['hxe_num_hora'];
    $totalHoras        += $monto_total_horas;
            ?>
            <tr <?php echo $noBr; ?>>
                <?php if ($tipo_reporte == '') : ?>
                    <td style="display:none;"><?php echo $registros; ?></td>
                <?php endif; ?>
                <td><?php echo $empleado; ?></td>
                <td><?php echo formatear_fecha('d-m-Y', $row['hxe_fecha'], 2); ?></td>
                <td><?php echo formatear_fecha('H:i:s a', $row['hxe_hora_inicio'], 2); ?></td>
                <td><?php echo formatear_fecha('H:i:s a', $row['hxe_hora_fin'], 2); ?></td>
                <td><?php echo $row['ord_codigo']; ?></td>
                <td><?php echo number_format($row['hxe_num_hora'], 2); ?></td>
                <td>$<?php echo number_format($precio, 2); ?></td>
                <td>$<?php echo number_format($monto_total_horas, 2); ?></td>
            </tr>
            <?php
            $i++;
            ?>
        <?php
        $registros++;
    endforeach;
        ?>
        <tr>
            <?php if ($tipo_reporte != '') : ?>
                <td colspan="6"></td>
            <?php else : ?>
                <td style="display:none;"><?php echo $registros; ?></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            <?php endif; ?>
            <td><b>Total</b></td>
            <td><b>$<?php echo number_format($totalHoras, 2); ?></b></td>
        </tr>
        <?php if ($tipo_reporte != '') {
        ?>

                </tbody>
            </table>
        <?php }
        ?>