<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Cursograma Analítico
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<style type="text/css">
    .totales {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }

    .titulo {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }
</style>


<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla td {
            vertical-align: middle;
            text-align: center;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
            font-size: 10;
        }
    </style>
<?php } ?>
<!-- Encabezado -->
<?php if ($tipo_reporte != '') { ?>
    <table>
        <tr>
            <td><b>Diagrama Num:</b> <?php echo $analisis[0]["cra_codigo"]; ?></td>
            <td></td>
        </tr>
        <tr>
            <td><b>Objeto:</b> <?php echo $analisis[0]["art_nombre"]; ?></td>
            <td><b>Actividad:</b> <?php echo $analisis[0]["cra_actividad"]; ?></td>
        </tr>
        <tr>
            <td></td>
            <td><b>Método:</b> Actual/Propuesto</td>
        </tr>
        <tr>
            <td><b>Lugar:</b> <?php echo $analisis[0]["cra_lugar"]; ?></td>
            <td></td>
        </tr>
        <tr>
            <td><b>Operarios (s):</b> <?php echo $analisis[0]["emp_nombre"] . " " . $analisis[0]["emp_apellido"]; ?></td>
            <td></td>
        </tr>
        <tr>
            <td><b>Compuesto por:</b> <?php echo $creador; ?></td>
            <td><b>Fecha:</b> <?php echo date('Y-m-d', strtotime($analisis[0]["cra_fecha"])); ?></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
        </tr>
    </table>
<?php } ?>

<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
    <?php } else { ?>
        <table class="responsive display table table-bordered dataTable" id="tbl_facturas" name="tbl_facturas" border="0" style="margin-left: 4px; width: 99%; font-size:12px;">
        <?php } ?>
        <thead>
            <tr>
                <th rowspan="2" width="26%">Descripción</th>
                <th rowspan="2" width="8%">Cantidad</th>
                <th rowspan="2" width="8%">Tiempo</th>
                <th rowspan="2" width="8%">Distancia</th>
                <th colspan="5" width="25%">Símbolo</th>
                <th rowspan="2" width="25%">Observaciones</th>
            </tr>
            <tr>
                <th>Op.</th>
                <th>Ins.</th>
                <th>Dem.</th>
                <th>Tran.</th>
                <th>Alm.</th>
            </tr>
        </thead>
        <tbody id="tbl_contenedor_clientes">
            <?php
            if (count($analisis) > 0) {
                //declaracion de varaibles
                $tabla          = "";
                $operacion      = 0; //1
                $inspeccion     = 0; //2
                $demora         = 0; //3
                $transporte     = 0; //4 
                $almacenamiento = 0; //5
                $total_cantidad = 0;
                $total_distancia = 0;
                $total_tiempo   = 0;

                foreach ($analisis as $fila) {
                    $total_cantidad += $fila["exg_cantidad"];
                    $total_distancia += $fila["exg_distancia"];
                    $total_tiempo   += $fila["exg_tiempo"];

                    switch ($fila["exg_id_eca"]) {
                        case 1:
                            $operacion++;
                            break;
                        case 2:
                            $inspeccion++;
                            break;
                        case 3:
                            $demora++;
                            break;
                        case 4:
                            $transporte++;
                            break;
                        case 5:
                            $almacenamiento++;
                            break;
                    }

                    $tabla .= '<tr>';
                    $tabla .= '<td width="26%">' . $fila["exg_descripcion"] . '</td>';
                    $tabla .= '<td width="8%">' . number_format($fila["exg_cantidad"], 2) . '</td>';
                    $tabla .= '<td width="8%">' . number_format($fila["exg_tiempo"], 2) . '</td>';
                    $tabla .= '<td width="8%">' . number_format($fila["exg_distancia"], 2) . '</td>';

                    $tabla .= '<td width="5%">';
                    $tabla .= ($fila["exg_id_eca"] == 1) ? 'x' : '';
                    $tabla .= '</td>';

                    $tabla .= '<td width="5%">';
                    $tabla .= ($fila["exg_id_eca"] == 2) ? "x" : "";
                    $tabla .= '</td>';

                    $tabla .= '<td width="5%">';
                    $tabla .= ($fila["exg_id_eca"] == 3) ? "x" : "";
                    $tabla .= '</td>';

                    $tabla .= '<td width="5%">';
                    $tabla .= ($fila["exg_id_eca"] == 4) ? "x" : "";
                    $tabla .= '</td>';

                    $tabla .= '<td width="5%">';
                    $tabla .= ($fila["exg_id_eca"] == 5) ? "x" : "";
                    $tabla .= '</td>';

                    $tabla .= '<td width="25%">' . $fila["exg_observacion"] . '</td>';

                    $tabla .= '</tr>';
                }

                echo $tabla;
            }
            ?>
        </tbody>
        <tfoot>
            <tr>
                <td width="26%" style="text-align:right"><b>Total</b></td>
                <td width="8%"><b><?php echo $total_cantidad; ?></b></td>
                <td width="8%"><b><?php echo $total_tiempo; ?></b></td>
                <td width="8%"><b><?php echo $total_distancia; ?></b></td>
                <td width="5%"><b><?php echo $operacion; ?></b></td>
                <td width="5%"><b><?php echo $inspeccion; ?></b></td>
                <td width="5%"><b><?php echo $demora; ?></b></td>
                <td width="5%"><b><?php echo $transporte; ?></b></td>
                <td width="5%"><b><?php echo $almacenamiento; ?></b></td>
                <td width="25%"><b></b></td>
            </tr>
        </tfoot>
        </table>
        <br>
        <br>
        <br>
        <?php if ($tipo_reporte != '') { ?>
            <table>
                <tr>
                    <td width="26%"></td>
                    <td>
                        <table border="1">
                            <thead>
                                <tr>
                                    <th colspan="4" style="text-align:center;"><b>Resumen</b></th>
                                </tr>
                                <tr>
                                    <th style="text-align:center;"><b>Actividad</b></th>
                                    <th style="text-align:center;"><b>Actual</b></th>
                                    <th style="text-align:center;"><b>Propuesta</b></th>
                                    <th style="text-align:center;"><b>Economía</b></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Operación</td>
                                    <td><b><?php echo $operacion; ?></b></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>Inspección</td>
                                    <td><b><?php echo $inspeccion; ?></b></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>Demora</td>
                                    <td><b><?php echo $demora; ?></b></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>Transporte</td>
                                    <td><b><?php echo $transporte; ?></b></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>Almacenamiento</td>
                                    <td><b><?php echo $almacenamiento; ?></b></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>Distancia(m)</td>
                                    <td><b><?php echo $total_distancia; ?></b></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>Tiempo (min-hombre)</td>
                                    <td><b><?php echo $total_tiempo; ?></b></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>Costo <br>- Mano de obra <br>- Material</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>

                            </tbody>
                            <tfoot>
                                <tr>
                                    <td><b>Total</b></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>

                    </td>
                </tr>
            </table>
        <?php } ?>