<?php

//Numero de decimales segun el parametro en la BD
$num_dec = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<?php if ($tipo_reporte != '' && $tipo_reporte == 'pdf') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 0.5px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 0.5px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte != '' && $tipo_reporte == 'excel') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
            border: 2px solid black;
        }

        .tabla th {
            border: 2px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
            font-size: 12px !important;
        }

        .tabla td {
            border: 2px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Costo por Orden de Producción
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php
}

$nombre_cliente = ($orden[0]['cli_personeria'] == 1) ? $orden[0]['cli_nombre'] . ' ' . $orden[0]['cli_apellido'] : $orden[0]['cli_apellido'];
?>
<table class="" cellpadding="2">
    <tbody>
        <tr>
            <td colspan="4"></td>
        </tr>
        <tr>
            <td style="text-align: left;width: 8%;"><b>Cliente:</b></td>
            <td style="text-align: left;"><?php echo $nombre_cliente; ?></td>
            <td style="text-align: left;width: 12%;"></td>
            <td style="text-align: left;"></td>
        </tr>
        <tr>
            <td style="text-align: left;width: 8%;"><b>Orden:</b></td>
            <td style="text-align: left;"><?php echo $orden[0]['ord_codigo']; ?></td>
            <td style="text-align: left;width: 12%;"><b>Fecha Orden:</b></td>
            <td style="text-align: left;"><?php echo formatear_fecha('d-m-Y', $orden[0]['ord_fecha']); ?></td>
        </tr>
    </tbody>
</table>
<div></div>
<?php $clases = ($tipo_reporte != 'excel') ? 'responsive table table-bordered contenedor' : ''; ?>
<table class="tabla <?php echo $clases; ?>" cellpadding="2">
    <tbody class="tabla">
        <?php if ($tipo_reporte == '') : ?>
            <tr>
                <td colspan="13" style="text-align: center;"></td>
            </tr>
        <?php endif; ?>
        <?php
        $registros = 1;
        $totalMateriaPrima = 0;
        $totalManoObra = 0;
        $totalGastosIndirectos = 0;
        foreach ($detalle_orden as $key => $row) :
        ?>
            <tr>
                <td colspan="13" style="text-align: left;background-color: #ced2d4;">
                    Producto: <b><?php echo $row['art_codigo'] . ' - ' . $row['art_nombre']; ?></b>
                </td>
            </tr>
            <tr>
                <td colspan="13" style="text-align: left;background-color: #ced2d4;">
                    Cantidad a Producir: <b><?php echo $row['axo_cantidad']; ?></b>
                </td>
            </tr>
            <?php
            $materia_prima = $this->proyecto_model->get_materia_prima_presupuesto(array('axm_id_axo' => $row['axo_id']));
            $mano_obra = $this->proyecto_model->get_mano_obra_presupuesto(array('mxo_id_axo' => $row['axo_id']));
            $gastos_indirectos = $this->proyecto_model->get_gastos_indirectos_presupuesto(array('exr_id_axo' => $row['axo_id']));


            $totalMateriales = count($materia_prima);
            $totalMano = count($mano_obra);
            $totalGastosIn = count($gastos_indirectos);

            $maximoRegistros = max($totalMateriales, $totalMano, $totalGastosIn);

            //Materia Prima
            if (count($maximoRegistros) > 0) :
                $totalMp = 0;
                $totalMob = 0;
                $totalGst = 0;
            ?>
                <tr>
                    <th colspan="5">Materia Prima</th>
                    <th colspan="4">Mano de Obra</th>
                    <th colspan="4">Gastos Indirectos</th>
                </tr>
                <tr style="<?php echo ($tipo_reporte != '') ? "font-size: 7px;" : "" ?>">
                    <th>Nombre</th>
                    <th>Cantidad</th>
                    <th>UM</th>
                    <th>Costo Unit.</th>
                    <th>Costo Total</th>
                    <th>Descripción</th>
                    <th>Cantidad</th>
                    <th>Costo Unit.</th>
                    <th>Costo Total</th>
                    <th>Descripción</th>
                    <th>Cantidad</th>
                    <th>Costo Unit.</th>
                    <th>Costo Total</th>
                </tr>
                <?php
                for ($i = 0; $i < $maximoRegistros; $i++) :

                    //Materia Prima
                    $nombreMp = (isset($materia_prima[$i]['axm_id']) && $materia_prima[$i]['axm_id'] != null) ? $materia_prima[$i]['art_codigo'] . ' - ' . $materia_prima[$i]['art_nombre'] : null;
                    $cantidadMp = (isset($materia_prima[$i]['axm_id']) && $materia_prima[$i]['axm_id'] != null) ? $materia_prima[$i]['axm_cantidad'] : null;
                    $medidaMp = (isset($materia_prima[$i]['axm_id']) && $materia_prima[$i]['axm_id'] != null) ? $materia_prima[$i]['mep_nombre'] : null;
                    $precioMp = (isset($materia_prima[$i]['axm_id']) && $materia_prima[$i]['axm_id'] != null) ? $materia_prima[$i]['axm_precio'] : null;
                    $subtotalMp = $cantidadMp * $precioMp;
                    $subtotalMpString = ($cantidadMp != null && $precioMp != null) ? $subtotalMp : null;
                    $totalMp += $subtotalMp;

                    //Mano de Obra
                    $nombreMob = (isset($mano_obra[$i]['mxo_id']) && $mano_obra[$i]['mxo_id'] != null) ? $mano_obra[$i]['mob_nombre'] : null;
                    $cantidadMob = (isset($mano_obra[$i]['mxo_id']) && $mano_obra[$i]['mxo_id'] != null) ? $mano_obra[$i]['mxo_cantidad'] : null;
                    $precioMob = (isset($mano_obra[$i]['mxo_id']) && $mano_obra[$i]['mxo_id'] != null) ? $mano_obra[$i]['mxo_precio'] : null;
                    $subtotalMob = $cantidadMob * $precioMob;
                    $subtotalMobString = ($cantidadMob != null && $precioMob != null) ? $subtotalMob : null;
                    $totalMob += $subtotalMob;

                    //Gastos Indirectos
                    $nombreGst = (isset($gastos_indirectos[$i]['exr_id']) && $gastos_indirectos[$i]['exr_id'] != null) ? $gastos_indirectos[$i]['esm_nombre'] : null;
                    $cantidadGst = (isset($gastos_indirectos[$i]['exr_id']) && $gastos_indirectos[$i]['exr_id'] != null) ? $gastos_indirectos[$i]['exr_cantidad'] : null;
                    $precioGst = (isset($gastos_indirectos[$i]['exr_id']) && $gastos_indirectos[$i]['exr_id'] != null) ? $gastos_indirectos[$i]['exr_monto_calculo'] : null;

                    //----------------------------------------------------------------------------
                    $verify_gasto_in = $gastos_indirectos[$i]['esm_tipo_calculo'];

                    $cantidad_gasto =
                        (isset($gastos_indirectos[$i]['exr_id']) && $gastos_indirectos[$i]['exr_id'] != null)
                        ? $gastos_indirectos[$i]['exr_cantidad'] : ($gastos_indirectos[$i]['esr_cantidad'] * $row['axo_cantidad']);

                    $precio_gasto = (isset($gastos_indirectos[$i]['exr_id']) && $gastos_indirectos[$i]['exr_id'] != null)
                        ? $gastos_indirectos[$i]['exr_precio'] : $gastos_indirectos[$i]['esr_precio'];

                    //$evito = isset($gasto_indirectos[0]['exa_cantidad']) ? $gasto_indirectos[0]['exa_cantidad'] : 0;

                    if ($verify_gasto_in == 1) {
                        $cantidad_gasto = (isset($gastos_indirectos[$i]['exr_id']) && $gastos_indirectos[$i]['exr_id'] != null)
                            ? $gastos_indirectos[$i]['exr_cantidad'] : ($gastos_indirectos[$i]['esr_cantidad']);
                        $subtotalGst = ($cantidad_gasto * $precio_gasto);
                        if ($cantidad_gasto == 0) {
                            $subtotalGst = number_format(0, $num_dec);
                        }
                        //print_r('asasasasas'.$precio_gasto);die();
                    } else {
                        $cantidad_gasto = (isset($gastos_indirectos[$i]['exr_id']) && $gastos_indirectos[$i]['exr_id'] != null)
                            ? $gastos_indirectos[$i]['exr_cantidad'] : ($gastos_indirectos[$i]['esr_cantidad']);

                        $subtotalGst = (isset($gastos_indirectos[$i]['exr_id']) && $gastos_indirectos[$i]['exr_id'] != null)
                            ? $gastos_indirectos[$i]['exr_monto_calculo'] : $gastos_indirectos[$i]['esr_monto_calculo'];
                    }
                    // $gasto_indirectos = $subtotalGasto;

                    //----------------------------------------------------------------------------------------
                    // $subtotalGst = $cantidadGst * $precioGst;
                    $subtotalGstString = ($cantidadGst != null && $precioGst != null) ? $subtotalGst : null;
                    $totalGst += $subtotalGst;
                ?>
                    <tr>
                        <td><?php echo $nombreMp; ?></td>
                        <td><?php echo $cantidadMp; ?></td>
                        <td><?php echo $medidaMp; ?></td>
                        <td><?php echo ($precioMp != '') ? $simbolo . number_format($precioMp, $num_dec) : ""; ?></td>
                        <td><?php echo ($subtotalMpString != '') ? $simbolo . number_format($subtotalMpString, $num_dec) : ""; ?></td>

                        <td><?php echo $nombreMob; ?></td>
                        <td><?php echo $cantidadMob; ?></td>
                        <td><?php echo ($precioMob != '') ? $simbolo . number_format($precioMob, $num_dec) : ""; ?></td>
                        <td><?php echo ($subtotalMob != '') ? $simbolo . number_format($subtotalMob, $num_dec) : ""; ?></td>

                        <td><?php echo $nombreGst; ?></td>
                        <td><?php echo $cantidadGst; ?></td>
                        <td><?php echo ($precioGst != '') ? $simbolo . number_format($precioGst, $num_dec) : ""; ?></td>
                        <td><?php echo ($subtotalGst != '') ? $simbolo . number_format($subtotalGst, $num_dec) : ""; ?></td>

                    </tr>
                <?php endfor; ?>
                <tr>
                    <td colspan="4"><b>Subtotales</b></td>
                    <td><?= $simbolo ?><?php echo number_format($totalMp, $num_dec); ?></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td><?= $simbolo ?><?php echo number_format($totalMob, $num_dec); ?></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td><?= $simbolo ?><?php echo number_format($totalGst, $num_dec); ?></td>
                </tr>
                <tr>
                    <td colspan="13" style="text-align: center;"></td>
                </tr>
                <!--<tr>
                <td colspan="4"></td>
                <td><b>Total</b></td>
                <td><?= $simbolo ?><?php
                                    $totalMateriaPrima += $totalMp;
                                    $totalManoObra += $totalMob;
                                    $totalGastosIndirectos += $totalGst;
                                    echo number_format($totalMp, $num_dec);
                                    ?></td>
                </tr>-->
            <?php endif; ?>
        <?php
            //End Productos
            $registros++;
        endforeach;
        $totalGeneral = $totalMateriaPrima + $totalManoObra + $totalGastosIndirectos;
        ?>
        <tr>
            <td colspan="6" style="">Materia Prima</td>
            <td colspan="7" style=""><?= $simbolo ?><?php echo number_format($totalMateriaPrima, $num_dec); ?></td>
        </tr>
        <tr>
            <td colspan="6" style="">Mano de Obra</td>
            <td colspan="7" style=""><?= $simbolo ?><?php echo number_format($totalManoObra, $num_dec); ?></td>
        </tr>
        <tr>
            <td colspan="6" style="">Estimación de Gastos</td>
            <td colspan="7" style=""><?= $simbolo ?><?php echo number_format($totalGastosIndirectos, $num_dec); ?></td>
        </tr>
        <tr>
            <td colspan="6" style="font-weight: bold;">Total</td>
            <td colspan="7" style="font-weight: bold;"><?= $simbolo ?><?php echo number_format($totalGeneral, $num_dec); ?></td>
        </tr>
    </tbody>
</table>