<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Horas Extras
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
//Si la variable tipo reporte existe se declara la tabla
$i = 1;
$registros = 1;
$pagina = null;
$noBr = ($tipo_reporte != '' && $tipo_reporte == 'pdf') ? 'nobr="true"' : '';
$totalPorcOrden = 0;
foreach ($detalle_orden as $row) :
    if ($tipo_reporte != '') {

        if ($registros == 1) {

            $nombre_cliente = ($orden[0]['cli_personeria'] == 1) ? $orden[0]['cli_nombre'] . ' ' . $orden[0]['cli_apellido'] : $orden[0]['cli_apellido'];
?>
            <table class="">
                <tr>
                    <td colspan="4"></td>
                </tr>
                <tr>
                    <td style="text-align: left;width: 8%;"><b>Cliente:</b></td>
                    <td style="text-align: left;"><?php echo $nombre_cliente; ?></td>
                    <td style="text-align: left;width: 12%;"></td>
                    <td style="text-align: left;"></td>
                </tr>
                <tr>
                    <td colspan="4"></td>
                </tr>
                <tr>
                    <td style="text-align: left;width: 8%;"><b>Orden:</b></td>
                    <td style="text-align: left;"><?php echo $orden[0]['ord_codigo']; ?></td>
                    <td style="text-align: left;width: 12%;"><b>Fecha Orden:</b></td>
                    <td style="text-align: left;"><?php echo formatear_fecha('d-m-Y', $orden[0]['ord_fecha']); ?></td>
                </tr>
            </table>
            <div></div>
            <table class="tabla" cellpadding="2">
                <thead>
                    <tr>
                        <th>Producto</th>
                        <th>Avance</th>
                    </tr>
                </thead>
                <tbody>
            <?php
        }
    }
    $lotes_producto = $this->proyecto_model->get_avance_produccion_lotes(array('lop_id_axo' => $row['axo_id']));
    $porcentaje_avance = 0;
    if (count($lotes_producto) > 0) {

        $total_lotes = count($lotes_producto);
        $porcentajes = array_sum(array_column($lotes_producto, 'porc_avance'));

        $porcentaje_avance = $porcentajes / $total_lotes;
    }
    $totalPorcOrden += $porcentaje_avance;
            ?>
            <tr <?php echo $noBr; ?>>
                <?php if ($tipo_reporte == '') : ?>
                    <td style="display:none;"><?php echo $registros; ?></td>
                <?php endif; ?>
                <td><?php echo $row['art_nombre']; ?></td>
                <td><?php echo number_format(($porcentaje_avance * 100), 2); ?>%</td>
            </tr>
            <?php
            $i++;
            ?>
        <?php
        $registros++;
    endforeach;

    $num_productos = count($detalle_orden);
    $totalOrden = $totalPorcOrden / $num_productos;
        ?>
        <tr>
            <?php if ($tipo_reporte == '') : ?>
                <td style="display:none;"><?php echo $registros; ?></td>
            <?php endif; ?>
            <td><b>Total Proyecto</b></td>
            <td><b><?php echo number_format(($totalOrden * 100), 2); ?>%</b></td>
        </tr>
        <?php if ($tipo_reporte != '') {
        ?>

                </tbody>
            </table>
        <?php }
        ?>