<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4>
                    <span>Filtros </span>
                </h4>
                <a href="#" class="minimize" style="display: none;">Minimize</a>
            </div>
            <div class="content">
                <div class="form-row row-fluid">
                    <div class="span12">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Desde: <b class="red">*</b></label>
                                <div class="span7 controls labels-info">
                                    <input type="text" name="fecha_ini" id="fecha_ini" class="nostyle calendario" value="<?php echo date('01-m-Y'); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Hasta: <b class="red">*</b></label>
                                <div class="span7 controls labels-info">
                                    <input type="text" name="fecha_fin" id="fecha_fin" class="nostyle calendario" value="<?php echo date('t-m-Y'); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="span12">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Cliente:</label>
                                <div class="span7 controls labels-info">
                                    <input type="hidden" id="slcCliente" class="nostyle">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="span12">
                        <div class="span6">
                            <div class="row-fluid">
                                <button type="button" id="btnConsultar" class="btn btn-success">Consultar</button>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <div style="text-align: right; display: none;" id="acciones">
                                    <form target="_blank" action="<?= base_url(); ?>proyectos/reportes/ordenes_finalizadas" method="POST">
                                        <input type="hidden" name="hdn_fec_ini" id="hdn_fec_ini" />
                                        <input type="hidden" name="hdn_fec_fin" id="hdn_fec_fin" />
                                        <input type="hidden" name="hdn_cliente" id="hdn_cliente" />
                                        <button type="submit" name="tipo_reporte" class="btn btn-success" value="pdf"><span class="icomoon-icon-file-pdf">Generar PDF</span></button>
                                        <button type="submit" name="tipo_reporte" class="btn btn-success" value="excel"><span class="icomoon-icon-file-excel">Generar EXCEL</span></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="box">
            <div class="title">
                <h4>
                    <span>Detalles</span>
                </h4>
                <a href="#" class="minimize" style="display: none;">Minimize</a>
            </div>
            <div class="noPad content">
                <div class="row-fluid">
                    <div class="span12" id="dvResultado">
                        <div class="content noPad clearfix" id="dv_contenedor_listado" style="overflow: auto;">
                            <table id="tblListado" class="responsive display table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Código Orden</th>
                                        <th>Cliente</th>
                                        <th>Producto</th>
                                        <th>Cantidad Planeada</th>
                                        <th>Cantidad Producida</th>
                                        <th>Fecha Finalización</th>
                                    </tr>
                                </thead>
                                <tbody id="tbContenedorListado">
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <br>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {

        $(".calendario").datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            closeText: 'Cerrar',
            currentText: 'Hoy'
        });

        $("body").on("change", "#fecha_ini, #fecha_fin", function() {
            verifica_fecha($('#fecha_ini').val(), $('#fecha_fin').val());
        });

        $("#slcCliente").select2({
            placeholder: "Buscar Cliente",
            minimumInputLength: 3,
            ajax: {
                url: urlj + 'proyectos/procesos/get_clientes_like',
                dataType: 'json',
                type: 'POST',
                delay: 250,
                data: function(cliente) {
                    return {
                        cliente: cliente
                    };
                },
                results: function(data) {
                    var myResults = [];
                    $.each(data, function(index, item) {
                        myResults.push({
                            'id': item.cliente,
                            'text': item.cliente_nombre
                        });
                    });
                    return {
                        results: myResults
                    };
                }
            }
        });

        $("#btnConsultar").click(function() {
            $("#acciones").hide();
            var fecha_ini = $("#fecha_ini").val();
            var fecha_fin = $("#fecha_fin").val();
            var cliente = $("#slcCliente").val();
            if (fecha_ini != "" && fecha_fin != "") {
                $.ajax({
                    type: 'post',
                    url: urlj + 'proyectos/reportes/ordenes_finalizadas/1',
                    data: {
                        fecha_ini: fecha_ini,
                        fecha_fin: fecha_fin,
                        tipo_reporte: "",
                        cliente: cliente,
                    },
                    beforeSend: function() {
                        wait.start();
                    },
                    success: function(data) {
                        $('#tbContenedorListado').html(data);
                        $("#hdn_fec_ini").val(fecha_ini);
                        $("#hdn_fec_fin").val(fecha_fin);
                        $("#hdn_cliente").val(cliente);
                        $("#acciones").show();
                        wait.close();
                    }
                });
            } else {
                crear_alerta('error', 'Fechas', 'Fechas del período son requeridas.');
            }
        });

    });

    function verifica_fecha(fecha_ini, fecha_fin) {
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");
        if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
            crear_alerta('error', 'Fechas', 'Verifique las fechas del período');
            return false;
        } else {
            return true;
        }
    }
</script>