<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
$pdf = ($reporte == 'pdf') ? true : false;
if ($reporte == 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
}

if ($reporte == 'excel') {
?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Costeo de Producto
                    </h4>
                </td>
            </tr>
        </table>
    </div>
    <br>
<?php
}
?>
<div>
    <table border="<?= ($pdf) ? 0 : 1; ?>" width="100%" class="table">
        <tr>
            <th width="10%"><b>Producto:</b></th>
            <th width="55%"><?php echo $articulo[0]['art_codigo'] . ' - ' . $articulo[0]['art_nombre']; ?></th>
            <th width="15%"><b>Presentación:</b></th>
            <th width="20%"><?php echo $cva_medida; ?></th>
        </tr>
    </table>
    <?php
    if ($vacio > 0) {
    ?>
        <table width="100%" border="1" class="table">
            <tr>
                <th style="text-align: center;"><b>No se han encontrado registros para este producto</b></th>
            </tr>
        </table>
    <?php
    } else {
        $total_general = 0;
        echo ($reporte == 'excel') ? '<br><br>' : '';
    ?>
        <table width="100%" border="1" class="table-bordered table">
            <thead style="text-align:center">
                <tr>
                    <td colspan="8" style="text-align: center;"><b>MATERIA PRIMA</b></td>
                </tr>
                <tr>
                    <th <?= ($pdf) ? 'width="18%"' : ''; ?>><b>Nombre del Producto</b></th>
                    <th <?= ($pdf) ? 'width="10%"' : ''; ?>><b>Unidad de Medida</b></th>
                    <th <?= ($pdf) ? 'width="18%"' : ''; ?>><b>Proveedor</b></th>
                    <th <?= ($pdf) ? 'width="10%"' : ''; ?>><b>Etapa</b></th>
                    <th <?= ($pdf) ? 'width="11%"' : ''; ?>><b>Tipo Precio</b></th>
                    <th <?= ($pdf) ? 'width="11%"' : ''; ?>><b>Cantidad</b></th>
                    <th <?= ($pdf) ? 'width="11%"' : ''; ?>><b>Precio Unitario</b></th>
                    <th <?= ($pdf) ? 'width="11%"' : ''; ?>><b>Total</b></th>
                </tr>
            </thead>
            <tbody>
                <?php
                $total_materiales = 0;
                if (count($mat_prima) > 0) {
                    foreach ($mat_prima as $key => $mat) {
                        $proveedor = ($mat['prv_tipo_pers'] != '') ? $mat['prv_codigo'] : '';
                        $nombre = ($mat['prv_tipo_pers'] == 1) ? $mat['prv_nombre'] . ' ' . $mat['prv_apellido'] : $mat['prv_apellido'];
                        $prv_nombre = ($proveedor != "") ? $proveedor . ' - ' . $nombre : '<center>---</center>';
                        $cantidad = number_format($mat['mpa_cantidad'], $decimal, '.', '');
                        $precio = number_format($mat['tipos_precio'], $decimal, '.', '');
                        $sub_total = ($cantidad * $precio);
                        $total_materiales += $sub_total;
                        if ($mat['mpa_tipo_precio'] > 3) {
                            $tipo_precio = 'Precio Fijo';
                        } elseif ($mat['mpa_tipo_precio'] > 2) {
                            $tipo_precio = 'Última producción';
                        } elseif ($mat['mpa_tipo_precio'] > 1) {
                            $tipo_precio = 'Última compra';
                        } else {
                            $tipo_precio = 'Costo promedio';
                        }
                ?>
                        <tr>
                            <td <?= ($pdf) ? 'width="18%"' : ''; ?>><?php echo $mat['art_codigo'] . ' - ' . $mat['art_nombre']; ?></td>
                            <td <?= ($pdf) ? 'width="10%"' : ''; ?>><?php echo $mat['mep_nombre']; ?></td>
                            <td <?= ($pdf) ? 'width="18%"' : ''; ?>><?php echo $prv_nombre; ?></td>
                            <td <?= ($pdf) ? 'width="10%"' : ''; ?>><?php echo ($mat['etapa_nombre'] != "") ? $mat['etapa_nombre'] : '<center>---</center>'; ?></td>
                            <td <?= ($pdf) ? 'width="11%"' : ''; ?>><?php echo $tipo_precio; ?></td>
                            <td style="text-align: right;" <?= ($pdf) ? 'width="11%"' : ''; ?>><?php echo $cantidad; ?></td>
                            <td <?= ($pdf) ? 'width="11%"' : ''; ?> style="text-align: right;"><?= $simbolo ?><?php echo $precio; ?></td>
                            <td <?= ($pdf) ? 'width="11%"' : ''; ?> style="text-align: right;"><?= $simbolo ?><?php echo number_format($sub_total, $decimal); ?></td>
                        </tr>
                    <?php
                    }
                } else {
                    ?>
                    <tr>
                        <td style="text-align: center;" colspan="8"><b>No se han encontrado registros de Materia Prima para este producto</b></td>
                    </tr>
                <?php
                }
                ?>
            </tbody>
            <?php if (count($mat_prima) > 0) {
                $total_general += $total_materiales;
            ?>
                <tfoot>
                    <tr>
                        <th style="text-align: right;" colspan="7"><b>Total Materia Prima</b></th>
                        <th style="text-align: right;"><?= $simbolo ?><?php echo number_format($total_materiales, $decimal); ?></th>
                    </tr>
                </tfoot>
            <?php } ?>
        </table>
        <?php echo ($reporte == 'excel') ? '<br><br>' : ''; ?>
        <table width="100%" border="1" class="table-bordered table">
            <thead style="text-align:center">
                <tr>
                    <td colspan="5" style="text-align: center;"><b>MANO DE OBRA DIRECTA</b></td>
                </tr>
                <tr>
                    <th <?= ($pdf) ? 'width="25%"' : ''; ?>><b>Descripción</b></th>
                    <th <?= ($pdf) ? 'width="15%"' : ''; ?>><b>Cantidad</b></th>
                    <th <?= ($pdf) ? 'width="30%"' : ''; ?>><b>Responsable</b></th>
                    <th <?= ($pdf) ? 'width="15%"' : ''; ?>><b>Costo Unitario</b></th>
                    <th <?= ($pdf) ? 'width="15%"' : ''; ?>><b>Total</b></th>
                </tr>
            </thead>
            <tbody>
                <?php
                $total_mano_obra = 0;
                if (count($mano_obra) > 0) {
                    foreach ($mano_obra as $key => $mano) {
                        $ctdad_mano = number_format($mano['moa_cantidad'], $decimal, '.', '');
                        $costo_mano = ($mano['moa_precio'] != "") ? number_format($mano['moa_precio'], $decimal, '.', '') : number_format($mano['mob_precio'], $decimal, '.', '');
                        $responsable = ($mano['moa_id_emp'] != "") ? $mano['emp_codigo'] . ' - ' . $mano['emp_nombre'] . ' ' . $mano['emp_apellido'] : "";
                        $sub_tot_mo = ($ctdad_mano * $costo_mano);
                        $total_mano_obra += $sub_tot_mo;
                ?>
                        <tr>
                            <td <?= ($pdf) ? 'width="25%"' : ''; ?>><?php echo $mano['mob_codigo'] . ' - ' . $mano['mob_nombre']; ?></td>
                            <td <?= ($pdf) ? 'width="15%"' : ''; ?> style="text-align: right;"><?php echo $ctdad_mano; ?></td>
                            <td <?= ($pdf) ? 'width="30%"' : ''; ?>><?php echo $responsable; ?></td>
                            <td <?= ($pdf) ? 'width="15%"' : ''; ?> style="text-align: right;"><?= $simbolo ?><?php echo $costo_mano; ?></td>
                            <td <?= ($pdf) ? 'width="15%"' : ''; ?> style="text-align: right;"><?= $simbolo ?><?php echo number_format($sub_tot_mo, $decimal); ?></td>
                        </tr>
                    <?php
                    }
                } else {
                    ?>
                    <tr>
                        <td style="text-align: center;" colspan="5"><b>No se han encontrado registros de Mano de Obra Directa para este producto</b></td>
                    </tr>
                <?php
                }
                ?>
            </tbody>
            <?php if (count($mano_obra) > 0) {
                $total_general += $total_mano_obra;
            ?>
                <tfoot>
                    <tr>
                        <th style="text-align: right;" colspan="4"><b>Total Mano de Obra Directa</b></th>
                        <th style="text-align: right;"><?= $simbolo ?><?php echo number_format($total_mano_obra, $decimal); ?></th>
                    </tr>
                </tfoot>
            <?php } ?>
        </table>
        <?php echo ($reporte == 'excel') ? '<br><br>' : ''; ?>
        <table width="100%" border="1" class="table-bordered table">
            <thead>
                <tr>
                    <td colspan="5" style="text-align:center"><b>GASTOS INDIRECTOS DE FABRICACIÓN</b></td>
                </tr>
                <tr>
                    <th <?= ($pdf) ? 'width="40%"' : ''; ?>><b>Descripcion</b></th>
                    <th <?= ($pdf) ? 'width="15%"' : ''; ?>><b>Tipo de Calculo</b></th>
                    <th <?= ($pdf) ? 'width="15%"' : ''; ?>><b>Cantidad</b></th>
                    <th <?= ($pdf) ? 'width="15%"' : ''; ?>><b>Costo Unitario</b></th>
                    <th <?= ($pdf) ? 'width="15%"' : ''; ?>><b>Costo Total</b></th>
                </tr>
            </thead>
            <tbody>
                <?php
                $total_otros_gastos = 0;
                if (count($otros_gts) > 0) {
                    foreach ($otros_gts as $key => $gif) {
                        $cantidad_gif = number_format($gif['esr_cantidad'], $decimal, '.', '');
                        $precio_gasto = ($gif['esr_monto_calculo'] != "") ? $gif['esr_monto_calculo'] : $gif['esr_precio'];
                        $precio_gasto = number_format($precio_gasto, $decimal, '.', '');
                        if ($gif['esm_tipo_calculo'] > 0) {
                            $signo = "$";
                            $subtotal_gif = ($cantidad_gif * $precio_gasto);
                        } else {
                            $signo = "%";
                            $valor = ($precio_gasto / 100);
                            $total = 0;
                            if (count($mat_prima) > 0) {
                                foreach ($mat_prima as $j => $val) {
                                    $total += ($val['mpa_estimacion_porcentaje'] > 0) ? number_format(($val['tipos_precio'] * $val['mpa_cantidad']), $decimal, '.', '') : 0;
                                }
                            }
                            if (count($mano_obra) > 0) {
                                foreach ($mano_obra as $k => $vlr) {
                                    $costo_mano = ($vlr['moa_precio'] != "") ? $vlr['moa_precio'] : $vlr['mob_precio'];
                                    $total += ($vlr['moa_estimacion_porcentaje'] > 0) ? number_format(($costo_mano * $vlr['moa_cantidad']), $decimal, '.', '') : 0;
                                }
                            }
                            $subtotal_gif = ($total * $valor);
                        }
                        $precio_gif  = ($signo == "$") ? $signo : "";
                        $precio_gif .= $precio_gasto;
                        $precio_gif .= ($signo == "%") ? $signo : "";
                        $total_otros_gastos += $subtotal_gif;
                ?>
                        <tr>
                            <td <?= ($pdf) ? 'width="40%"' : ''; ?>><?php echo $gif['esm_codigo'] . ' - ' . $gif['esm_nombre']; ?></td>
                            <td <?= ($pdf) ? 'width="15%"' : ''; ?>><?php echo ($gif['esm_tipo_calculo'] > 0) ? 'Monto' : 'Porcentaje'; ?></td>
                            <td <?= ($pdf) ? 'width="15%"' : ''; ?> style="text-align: right;"><?php echo $cantidad_gif; ?></td>
                            <td <?= ($pdf) ? 'width="15%"' : ''; ?> style="text-align: right;"><?php echo $precio_gif; ?></td>
                            <td <?= ($pdf) ? 'width="15%"' : ''; ?> style="text-align: right;"><?php echo $simbolo . number_format($subtotal_gif, $decimal); ?></td>
                        </tr>
                    <?php
                    }
                } else {
                    ?>
                    <tr>
                        <td style="text-align: center;" colspan="5"><b>No se han encontrado registros de Gastos Indirectos de Fabricación para este producto</b></td>
                    </tr>
                <?php
                }
                ?>
            </tbody>
            <?php if (count($otros_gts) > 0) {
                $total_general += $total_otros_gastos;
            ?>
                <tfoot>
                    <tr>
                        <th style="text-align: right;" colspan="4"><b>Total Gastos Indirectos de Fabricación</b></th>
                        <th style="text-align: right;"><?= $simbolo ?><?php echo number_format($total_otros_gastos, $decimal); ?></th>
                    </tr>
                </tfoot>
            <?php } ?>
        </table>
        <?php echo ($reporte == 'excel') ? '<br><br>' : ''; ?>
        <table border="1" width="100%" class="table">
            <tr>
                <th width="75%" style="text-align: right;"><b>Costo Unitario Total:</b></th>
                <th width="25%" style="text-align: right;"><?= $simbolo ?><?php echo number_format($total_general, $decimal); ?></th>
            </tr>
        </table>
    <?php
    }
    ?>
</div>