<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4>
                    <span>Filtros </span>
                </h4>
                <a href="#" class="minimize" style="display: none;">Minimize</a>
            </div>
            <div class="content">
                <div class="form-row row-fluid">
                    <div class="span12">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Desde: <b class="red">*</b></label>
                                <div class="span7 controls labels-info">
                                    <input type="text" name="fecha_ini" id="fecha_ini" class="nostyle calendario" value="<?php echo date('d-m-Y'); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Hasta: <b class="red">*</b></label>
                                <div class="span7 controls labels-info">
                                    <input type="text" name="fecha_fin" id="fecha_fin" class="nostyle calendario" value="<?php echo date('d-m-Y'); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="span12">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Cliente:</label>
                                <div class="span7 controls labels-info">
                                    <input type="hidden" id="slcCliente" class="nostyle">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="span12">
                        <div class="span6">
                            <div class="row-fluid">
                                <button type="button" id="btnConsultar" class="btn btn-success">Consultar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="box">
            <div class="title">
                <h4>
                    <span>Detalles</span>
                </h4>
                <a href="#" class="minimize" style="display: none;">Minimize</a>
            </div>
            <div class="noPad content">
                <div class="row-fluid">
                    <div class="span12" id="dvResultado">
                        <div class="content noPad clearfix" id="dv_contenedor_listado" style="overflow-y: auto;">
                            <table id="tblListado" class="responsive display table table-bordered">
                                <thead>
                                    <tr>
                                        <th width="15%">Código Orden</th>
                                        <th width="15%">Fecha</th>
                                        <th width="45%">Cliente</th>
                                        <th width="25%">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody id="tbContenedorListado">
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <br>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {

        $(".calendario").datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            closeText: 'Cerrar',
            currentText: 'Hoy'
        });

        $("body").on("change", "#fecha_ini, #fecha_fin", function() {
            verifica_fecha($('#fecha_ini').val(), $('#fecha_fin').val());
        });

        $("#slcCliente").select2({
            placeholder: "Buscar Cliente",
            minimumInputLength: 3,
            ajax: {
                url: urlj + 'proyectos/procesos/get_clientes_like',
                dataType: 'json',
                type: 'POST',
                delay: 250,
                data: function(cliente) {
                    return {
                        cliente: cliente
                    };
                },
                results: function(data) {
                    var myResults = [];
                    $.each(data, function(index, item) {
                        myResults.push({
                            'id': item.cliente,
                            'text': item.cliente_nombre
                        });
                    });
                    return {
                        results: myResults
                    };
                }
            }
        });

        $("#btnConsultar").click(function() {
            var fecha_ini = $("#fecha_ini").val();
            var fecha_fin = $("#fecha_fin").val();
            var cliente = $("#slcCliente").val();
            if (fecha_ini != "" && fecha_fin != "") {
                $.ajax({
                    type: 'post',
                    url: urlj + 'proyectos/reportes/hoja_trabajo',
                    data: {
                        fecha_ini: fecha_ini,
                        fecha_fin: fecha_fin,
                        cliente: cliente
                    },
                    beforeSend: function() {
                        wait.start();
                    },
                    success: function(data) {
                        $('#tbContenedorListado').html(data);
                        wait.close();
                    }
                });
            } else {
                crear_alerta('error', 'Fechas', 'Fechas del período son requeridas.');
            }
        });

        $("#btnConsultar").trigger('click');

    });

    function verifica_fecha(fecha_ini, fecha_fin) {
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");
        if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
            crear_alerta('error', 'Fechas', 'Verifique las fechas del período');
            return false;
        } else {
            return true;
        }
    }
</script>