<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");

    $dec = "0\.";
    for ($i = 0; $i < $decimal; $i++) {
        $dec .= "0";
    }
?>
    <style type="text/css">
        .numero {
            mso-number-format: "<?= $dec ?>";
        }
    </style>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de estandar de producto
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php
}
if ($tipo_reporte != '') { ?>
    <table>
        <tr>
            <td style="width: 15%; text-align: left"><strong>Categoria:</strong></td>
            <td style="width: 35%; text-align: left"><?php echo $filtros['categoria'] ?></td>
            <td style="width: 15%; text-align: left"><strong>Producto:</strong></td>
            <td style="width: 35%; text-align: left"><?php echo $filtros['producto'] ?></td>
        </tr>
        <tr>
            <td style="width: 15%; text-align: left"><strong>Descripcion:</strong></td>
            <td style="width: 85%; text-align: left"><?php echo $filtros['descripcion'] ?></td>
        </tr>
    </table>
<?php } ?>
<table class="table" id="datagried" name="datagried" width="100%" <?= ($tipo_reporte != '') ? 'border="1"' : ''; ?>>
    <thead>
        <tr nobr="true">
            <th style="text-align: center;" colspan="7"><b>Materia Prima</b></th>
        </tr>
        <tr>
            <th><b>Código</b></th>
            <th><b>Descripción</b></th>
            <th><b>U. Medida</b></th>
            <th><b>Cantidad</b></th>
            <th><b>Costo</b></th>
            <th><b>Tipo Costo</b></th>
            <th><b>Subtotal</b></th>
        </tr>
    </thead>
    <tbody id="body_productos_dee">
        <?php
        $totalprima = 0.00;
        if (count($m_prima) > 0) {
            foreach ($m_prima as $key => $value) {
                $subtotal = ($value['mpa_cantidad'] * $value['mpa_precio']);
                $totalprima += $subtotal;
                if ($value['mpa_tipo_precio'] > 3) {
                    $tipo_precio = 'Precio Fijo';
                } elseif ($value['mpa_tipo_precio'] > 2) {
                    $tipo_precio = 'Última producción';
                } elseif ($value['mpa_tipo_precio'] > 1) {
                    $tipo_precio = 'Última compra';
                } else {
                    $tipo_precio = 'Costo promedio';
                }
        ?>
                <tr nobr="true">
                    <td><?php echo $value['art_codigo']; ?></td>
                    <td><?php echo $value['art_nombre']; ?></td>
                    <td><?php echo $value['mep_nombre']; ?></td>
                    <td><?php echo $value['mpa_cantidad']; ?></td>
                    <td class="numero" style="text-align: right;"><?= $simbolo ?><?php echo number_format($value['mpa_precio'], $decimal); ?></td>
                    <td><?php echo $tipo_precio; ?></td>
                    <td class="numero" style="text-align: right;"><?= $simbolo ?><?php echo number_format($subtotal, $decimal); ?></td>
                </tr>
            <?php
            } ?>
            <tr nobr="true">
                <td style="text-align: right;" colspan="6"><b>Total</b></td>
                <td class="numero" style="text-align: right;"><?= $simbolo ?><?php echo number_format($totalprima, $decimal); ?></td>
            </tr>
        <?php
        } else { ?>
            <tr nobr="true">
                <td style="text-align: center;" colspan="7"><b>No se encontraron datos de materia prima</b></td>
            </tr>
        <?php
        } ?>
    </tbody>
</table>
<br>
<table class="table" id="datagried" name="datagried" width="100%" <?= ($tipo_reporte != '') ? 'border="1"' : ''; ?>>
    <thead>
        <tr nobr="true">
            <th style="text-align: center;" colspan="5"><b>Mano de Obra</b></th>
        </tr>
        <tr nobr="true">
            <th><b>Código</b></th>
            <th><b>Descripción</b></th>
            <th><b>Cantidad</b></th>
            <th><b>Costo</b></th>
            <th><b>Subtotal</b></th>
        </tr>
    </thead>
    <tbody id="body_productos_dee">
        <?php
        $totalmano = 0;
        if (count($m_obra) > 0) {
            foreach ($m_obra as $key => $value) {
                $subtotalm = ($value['moa_cantidad'] * $value['mob_precio']);
                $totalmano += $subtotalm;
        ?>
                <tr nobr="true">
                    <td><?php echo $value['mob_codigo']; ?></td>
                    <td><?php echo $value['mob_nombre']; ?></td>
                    <td><?php echo $value['moa_cantidad']; ?></td>
                    <td class="numero" style="text-align: right;"><?= $simbolo ?><?php echo number_format($value['mob_precio'], $decimal); ?></td>
                    <td class="numero" style="text-align: right;"><?= $simbolo ?><?php echo number_format($subtotalm, $decimal); ?></td>
                </tr>
            <?php
            }
            ?>
            <tr nobr="true">
                <td style="text-align: right;" colspan="4"><b>Total</b></td>
                <td class="numero" style="text-align: right;"><?= $simbolo ?><?php echo number_format($totalmano, $decimal); ?></td>
            </tr>
        <?php
        } else {
        ?>
            <tr nobr="true">
                <td style="text-align: center;" colspan="5"><b>No se encontraron datos de materia prima</b></td>
            </tr>
        <?php
        }
        ?>
    </tbody>
</table>
<br>
<table class="table" id="datagried" name="datagried" width="100%" <?= ($tipo_reporte != '') ? 'border="1"' : ''; ?>>
    <thead>
        <tr nobr="true">
            <th colspan="6" style="text-align: center;"><b>Otros Gastos de Fabricación</b></th>
        </tr>
        <tr nobr="true">
            <th><b>Código</b></th>
            <th><b>Descripción</b></th>
            <th><b>Cantidad</b></th>
            <th><b>Tipo de Cálculo</b></th>
            <th><b>Costo</b></th>
            <th><b>Subtotal</b></th>
        </tr>
    </thead>
    <tbody id="body_productos_dee">
        <?php
        $totalgasto = 0;
        if (count($m_gasto) > 0) {
            foreach ($m_gasto as $key => $value) {
                $s1 = ($value['esm_tipo_calculo'] == 0) ? "" : "$";
                $s2 = ($value['esm_tipo_calculo'] == 0) ? "%" : "";
                $subtotalg = ($value['esm_tipo_calculo'] == 0 && $value['esr_monto_calculo'] != "") ? $value['esr_monto_calculo'] : ($value['esr_cantidad'] * $value['esr_precio']);
                $totalgasto += $subtotalg;
        ?>
                <tr nobr="true">
                    <td><?php echo $value['esm_codigo']; ?></td>
                    <td><?php echo $value['esm_nombre']; ?></td>
                    <td><?php echo $value['esr_cantidad']; ?></td>
                    <td><?php echo ($value['esm_tipo_calculo'] == 0) ? "Porcentaje" : "Monto"; ?></td>
                    <td class="numero" style="text-align: right;"><?php echo $s1 . number_format($value['esr_precio'], $decimal) . $s2; ?></td>
                    <td class="numero" style="text-align: right;"><?= $simbolo ?><?php echo number_format($subtotalg, $decimal); ?></td>
                </tr>
            <?php
            }
            ?>
            <tr nobr="true">
                <td style="text-align: right;" colspan="5"><b>Total</b></td>
                <td class="numero" style="text-align: right;"><?= $simbolo ?><?php echo number_format($totalgasto, $decimal); ?></td>
            </tr>
        <?php
        } else {
        ?>
            <tr nobr="true">
                <td style="text-align: center;" colspan="6"><b>No se encontraron datos de otros gastos indirectos de fabricación</b></td>
            </tr>
        <?php
        }
        ?>
    </tbody>
</table>
<br><?php
    if ($tipo_reporte != '') {
    ?><table width="100%" border="1">
        <tr>
            <td width="80%" style="text-align: right;"><b>TOTAL:</b></td>
            <td width="20%" class="numero" style="text-align: right;"><b><?= $simbolo ?><?php echo number_format(($totalprima + $totalmano + $totalgasto), $decimal); ?></b></td>
        </tr>
    </table>
<?php } ?>